/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.message;

import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;

public class ProfileMessageComponent
extends MessageComponent {
    public final Profile profile;
    private String displayName;

    public ProfileMessageComponent(Profile profile) {
        this.profile = profile;
        this.displayName = profile.getDisplayName();
        profile.addListener(this, ProfileMessageComponent::onProfileUpdate);
    }

    private void onProfileUpdate(Profile.ProfileEvent event) {
        if (!event.type.canChangeName()) {
            return;
        }
        assert (this.profile == event.profile) : "Profile update got a different profile???";
        String newName = this.profile.getDisplayName();
        if (this.profile.isFriend()) {
            newName = this.profile.getFriendName();
        }
        if (!newName.equals(this.displayName)) {
            this.displayName = newName;
            this.fire(this);
        }
    }

    @Override
    public String getMessage() {
        return this.displayName;
    }
}

