/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.request;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import org.jetbrains.annotations.Nullable;

public class ProfileResponse
extends ApiResponse {
    @Nullable
    private Map<String, ProfileData> profileData;

    public Set<String> getDataKeys() {
        return Collections.unmodifiableSet(Objects.requireNonNull(this.profileData).keySet());
    }

    @Nullable
    public ProfileData getData(String hash) {
        return Objects.requireNonNull(this.profileData).get(hash);
    }

    public static class ChatData {
        @Nullable
        private Map<String, String> hash;
        @Nullable
        private Boolean online;
    }

    public static class ProfileData {
        @Nullable
        private Map<String, String> hash;
        @Nullable
        private String friendCode;
        @Nullable
        private ChatData chat;
        @Nullable
        private Boolean cached;
        @Nullable
        private String display;
        @Nullable
        private Boolean hasAccount;
        @Nullable
        private Boolean premium;

        public String getLongHash() {
            Map<String, String> hashes = Objects.requireNonNull(this.hash);
            return Objects.requireNonNull(hashes.get("long"));
        }

        public String getFriendCode() {
            return Objects.requireNonNull(this.friendCode);
        }

        public boolean isOnline() {
            ChatData chat = Objects.requireNonNull(this.chat);
            return Objects.requireNonNull(chat.online);
        }

        public boolean isCached() {
            return Objects.requireNonNull(this.cached);
        }

        public String getDisplay() {
            return Objects.requireNonNull(this.display);
        }

        public boolean hasAccount() {
            return Objects.requireNonNull(this.hasAccount);
        }

        public boolean isPremium() {
            return Objects.requireNonNull(this.premium);
        }
    }
}

