/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import net.creeperhost.minetogether.lib.web.WebUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class ApiRequest<R> {
    protected static final Gson GSON = new Gson();
    protected static final Type STRING_MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    public final String method;
    public final String url;
    public final Type responseClass;
    public final Set<String> requiredAuthHeaders = new HashSet<String>();
    public final List<Pair<String, String>> queryParameters = new LinkedList<Pair<String, String>>();
    public final HeaderList headers = new HeaderList();
    @Nullable
    protected WebBody body;

    protected ApiRequest(String method, String url, Type responseClass) {
        this.method = method;
        this.url = url;
        this.responseClass = responseClass;
    }

    public Gson getGson() {
        return GSON;
    }

    protected void jsonBody(Object obj) {
        this.jsonBody(this.getGson(), obj);
    }

    protected void jsonBody(Gson gson, Object obj) {
        this.jsonBody(gson, obj, obj.getClass());
    }

    protected void jsonBody(Object obj, Type type) {
        this.jsonBody(this.getGson(), obj, type);
    }

    protected void jsonBody(Gson gson, Object obj, Type type) {
        assert (this.body == null) : "Body has already been set.";
        assert (WebUtils.permitsRequestBody(this.method)) : "Request does not permit a body";
        this.body = WebBody.string(gson.toJson(obj, type), "application/json");
    }

    protected void fillRequest(EngineRequest request) {
        assert (!WebUtils.requiresRequestBody(this.method) || this.body != null) : "HTTP Method " + this.method + " requires a body.";
        request.method(this.method, this.body);
        request.url(WebUtils.encodeQueryParameters(this.url, this.queryParameters));
        request.headers(this.headers);
    }
}

