/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class WebUtils {
    public static boolean permitsRequestBody(String method) {
        return !method.equalsIgnoreCase("GET") && !method.equalsIgnoreCase("HEAD");
    }

    public static boolean requiresRequestBody(String method) {
        return method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH") || method.equalsIgnoreCase("PROPPATCH") || method.equalsIgnoreCase("REPORT");
    }

    public static String encodeQueryParameters(String url, List<Pair<String, String>> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        builder.append("?");
        for (Pair<String, String> entry : parameters) {
            if (builder.charAt(builder.length() - 1) != '?') {
                builder.append("&");
            }
            try {
                builder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("UTF-8 is guaranteed to exist?", ex);
            }
        }
        return builder.toString();
    }
}

