/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.jetbrains.annotations.Nullable;

public class ApacheEngineRequest
implements EngineRequest {
    @Nullable
    private RequestBuilder builder;
    private final HeaderList headers = new HeaderList();

    @Override
    public EngineRequest method(String method, final @Nullable WebBody body) {
        assert (this.builder == null) : "Method already set";
        this.builder = RequestBuilder.create((String)method);
        if (body != null) {
            this.builder.setEntity((HttpEntity)new AbstractHttpEntity(){
                {
                    this.setContentType(body.contentType());
                }

                public void writeTo(OutputStream os) throws IOException {
                    try (InputStream is = this.getContent();){
                        IOUtils.copy(is, os);
                    }
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return body.length();
                }

                public InputStream getContent() throws IOException, UnsupportedOperationException {
                    return body.open();
                }

                public boolean isStreaming() {
                    return true;
                }
            });
        }
        return this;
    }

    @Override
    public EngineRequest url(String url) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.builder.setUri(url);
        return this;
    }

    @Override
    public EngineRequest header(String key, String value) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.add(key, value);
        return this;
    }

    @Override
    public EngineRequest headers(Map<String, String> headers) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest headers(HeaderList headers) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest removeHeader(String key) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.removeAll(key);
        return this;
    }

    @Override
    public String getUrl() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        assert (this.builder.getUri() != null) : "Url not set";
        return this.builder.getUri().toString();
    }

    @Override
    public HeaderList getHeaders() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        return this.headers;
    }

    public HttpUriRequest build() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        assert (this.builder.getUri() != null) : "Url not set";
        for (HeaderList.Entry header : this.headers) {
            this.builder.addHeader(header.name, header.value);
        }
        return this.builder.build();
    }
}

