/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.java11;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class Java11EngineRequest
implements EngineRequest {
    @Nullable
    private String url;
    @Nullable
    private String method;
    @Nullable
    private WebBody body;
    private final HeaderList headers = new HeaderList();

    @Override
    public EngineRequest method(String method, @Nullable WebBody body) {
        this.method = method;
        this.body = body;
        return this;
    }

    @Override
    public EngineRequest url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public EngineRequest header(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    @Override
    public EngineRequest headers(Map<String, String> headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest headers(HeaderList headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest removeHeader(String key) {
        this.headers.removeAll(key);
        return this;
    }

    @Override
    public String getUrl() {
        return Objects.requireNonNull(this.url, "URL not set yet.");
    }

    @Override
    public HeaderList getHeaders() {
        return this.headers;
    }

    public HttpRequest build() {
        String bodyContentType;
        Objects.requireNonNull(this.url, "URL not set.");
        Objects.requireNonNull(this.method, "Method not set.");
        if (this.body != null && this.headers.get("Content-Type") == null && (bodyContentType = this.body.contentType()) != null) {
            this.headers.add("Content-Type", bodyContentType);
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(URI.create(this.url));
        builder.method(this.method, this.body != null ? Java11EngineRequest.toPublisher(this.body) : HttpRequest.BodyPublishers.noBody());
        builder.headers(this.headers.toArray());
        return builder.build();
    }

    private static HttpRequest.BodyPublisher toPublisher(final WebBody body) {
        return new HttpRequest.BodyPublisher(){

            @Override
            public long contentLength() {
                return body.length();
            }

            @Override
            public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                HttpRequest.BodyPublisher delegate = HttpRequest.BodyPublishers.ofInputStream(() -> {
                    try {
                        return body.open();
                    }
                    catch (IOException ex) {
                        SneakyUtils.throwUnchecked(ex);
                        return null;
                    }
                });
                delegate.subscribe(subscriber);
            }
        };
    }
}

