/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.java11;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import net.creeperhost.minetogether.lib.web.EngineResponse;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import org.jetbrains.annotations.Nullable;

public class Java11EngineResponse
implements EngineResponse {
    private final HttpResponse<InputStream> response;
    private final HeaderList headers = new HeaderList();
    private final WebBody body;

    public Java11EngineResponse(HttpResponse<InputStream> response) {
        this.response = response;
        this.headers.addAllMulti(response.headers().map());
        this.body = new ResponseBodyWrapper(response, this.headers);
    }

    @Override
    public int statusCode() {
        return this.response.statusCode();
    }

    @Override
    public String message() {
        return null;
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() throws IOException {
    }

    private static final class ResponseBodyWrapper
    implements WebBody {
        private final HttpResponse<InputStream> response;
        private final HeaderList headers;

        public ResponseBodyWrapper(HttpResponse<InputStream> response, HeaderList headers) {
            this.response = response;
            this.headers = headers;
        }

        @Override
        public InputStream open() throws IOException {
            return this.response.body();
        }

        @Override
        public long length() {
            String len = this.headers.get("Content-Length");
            if (len == null) {
                return -1L;
            }
            return Long.parseLong(len);
        }

        @Override
        @Nullable
        public String contentType() {
            return this.headers.get("Content-Type");
        }
    }
}

