/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.java11;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.EngineResponse;
import net.creeperhost.minetogether.lib.web.WebEngine;
import net.creeperhost.minetogether.lib.web.java11.Java11EngineRequest;
import net.creeperhost.minetogether.lib.web.java11.Java11EngineResponse;

public class Java11WebEngine
implements WebEngine {
    private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).cookieHandler(new CookieManager()).build();

    @Override
    public EngineRequest newRequest() {
        return new Java11EngineRequest();
    }

    @Override
    public EngineResponse execute(EngineRequest r) throws IOException {
        HttpResponse<InputStream> response;
        if (!(r instanceof Java11EngineRequest)) {
            throw new IllegalArgumentException("Only supports executing Java11EngineRequests.");
        }
        HttpRequest request = ((Java11EngineRequest)r).build();
        try {
            response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException ex) {
            throw new IOException("Request failed. Interrupted.", ex);
        }
        return new Java11EngineResponse(response);
    }
}

