/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.okhttp;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Pair;
import net.creeperhost.minetogether.lib.web.EngineResponse;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Nullable;

public class OkHttpEngineResponse
implements EngineResponse {
    private final Response response;
    private final HeaderList headers = new HeaderList();
    @Nullable
    private final WebBody body;

    public OkHttpEngineResponse(Response response) {
        this.response = response;
        for (Pair header : response.headers()) {
            this.headers.add((String)header.component1(), (String)header.component2());
        }
        ResponseBody respBody = response.body();
        this.body = respBody != null ? new ResponseBodyWrapper(respBody) : null;
    }

    @Override
    public int statusCode() {
        return this.response.code();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() throws IOException {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
    }

    private static class ResponseBodyWrapper
    implements WebBody {
        private final ResponseBody body;
        @Nullable
        private final String contentType;

        public ResponseBodyWrapper(ResponseBody body) {
            this.body = body;
            MediaType contentType = body.contentType();
            this.contentType = contentType != null ? contentType.toString() : null;
        }

        @Override
        public InputStream open() throws IOException {
            return this.body.byteStream();
        }

        @Override
        public long length() {
            return this.body.contentLength();
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

