/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.gui.dialogs.ItemSelectDialog;
import net.creeperhost.minetogether.gui.dialogs.OptionDialog;
import net.creeperhost.minetogether.orderform.ServerOrderCallbacks;
import net.creeperhost.minetogether.orderform.data.AvailableResult;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.orderform.data.OrderSummary;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiScrolling;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextList;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstraintImpl;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OrderGui
implements GuiProvider {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RAND = new Random();
    private final Order order = new Order();
    private final Map<String, Integer> regionPing = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> dataCenterDistance = new ConcurrentHashMap<String, Integer>();
    private final Map<String, String> dataCenterUrls = new HashMap<String, String>();
    private final Map<String, Boolean> dataCenterAvailability = new HashMap<String, Boolean>();
    private final Map<String, String> regionMap = new HashMap<String, String>();
    private GuiTextField nameField;
    private GuiElement<?> locations;
    private String confirmPassword = "";
    private CompletableFuture<?> initTask;
    private CompletableFuture<?> pingTask;
    private CompletableFuture<?> orderTask;
    private CompletableFuture<?> availabilityTask;
    private volatile boolean nameValid = false;
    private volatile Component nameMessage = null;
    private int nameCheckTimer = 60;
    private int pingTimer = 0;
    private volatile boolean pingUpdated = false;
    private volatile boolean emailValid = false;
    private volatile Component emailMessage;
    private int emailCheckTimer = 60;
    private boolean inputsValid = false;
    private Component invalidMessage = null;
    private boolean summaryUpdateRequired = false;
    private volatile boolean summaryUpdating = false;
    private volatile OrderSummary summary = new OrderSummary("Loading Summary...");
    private volatile boolean loginMode = false;
    private boolean loggingIn = false;
    private boolean loggedIn = false;
    private String loggingInError = "";
    private int orderNumber;
    private String invoiceID;
    private volatile boolean processing = false;
    private Component processingText = Component.m_237119_();
    private GuiButton processingButton;
    private boolean processingShowCloseButton = false;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    private void initDefaults() {
        this.initTask = CompletableFuture.runAsync(() -> {
            this.regionMap.putAll(ServerOrderCallbacks.getRegionMap());
            for (String region : this.regionMap.keySet()) {
                this.regionPing.put(region, -1);
            }
            try {
                this.dataCenterDistance.putAll(ServerOrderCallbacks.getDataCentres());
                this.dataCenterUrls.putAll(ServerOrderCallbacks.getDataCentreURLs());
            }
            catch (IOException | URISyntaxException ex) {
                LOGGER.error("Failed to poll Data Centers.", (Throwable)ex);
            }
            this.order.serverLocation = this.datacentreToRegion(ServerOrderCallbacks.getRecommendedLocation());
            this.order.country = Countries.getOurCountry();
            this.summaryUpdateRequired = true;
        });
        this.order.name = OrderGui.getDefaultName();
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237115_((String)"minetogether:gui.order.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiElement orderBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-170.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)22.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-5.0));
        GuiElement priceBg = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.BOTTOM), (double)-17.0));
        GuiElement summaryBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)priceBg.get(GeoParam.TOP), (double)-2.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.m_237115_((String)"minetogether:gui.button.back_arrow")).onPress(() -> gui.mc().m_91152_(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton placeOrder = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(root, this::getOrderButtonText).onPress(() -> new OptionDialog((GuiParent<?>)this.locations.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:gui.order.place_order.confirm"), new Component[]{Component.m_237115_((String)"minetogether:gui.button.confirm").m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)"minetogether:gui.button.cancel").m_130940_(ChatFormatting.RED)}).onButtonPress(0, () -> this.placeOrder(gui)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)70.0))).setDisabled(() -> !this.inputsValid || this.orderTask != null || this.summaryUpdateRequired || this.summaryUpdating).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)priceBg.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)priceBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)priceBg.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.BOTTOM)));
        GuiScrolling scrollArea = new GuiScrolling((GuiParent)orderBg);
        scrollArea.getContentElement().constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)scrollArea.get(GeoParam.RIGHT)));
        Constraints.bind((ConstrainedGeometry)scrollArea, (ConstrainedGeometry)orderBg);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(orderBg, Axis.Y);
        ((GuiSlider)scrollBar.primary).setSliderState(scrollArea.scrollState(Axis.Y)).setScrollableElement((GuiElement)scrollArea);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> scrollArea.hiddenSize(Axis.Y) > 0.0).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)orderBg.get(GeoParam.RIGHT), (double)-4.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)orderBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        this.setupOrderPanel(scrollArea.getContentElement());
        this.setupSummaryPanel(summaryBg);
        this.setupPricePanel(priceBg);
        this.buildProcessingScreen(root);
        gui.onTick(() -> this.tick(gui));
        this.initDefaults();
    }

    private void setupOrderPanel(GuiElement<?> background) {
        ConstraintImpl.Relative left = Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)5.0);
        ConstraintImpl.Relative right = Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-5.0);
        GuiElement<?> lastElement = this.configSection(background, (Constraint)left, (Constraint)right);
        lastElement = this.locationSection(background, lastElement, (Constraint)left, (Constraint)right);
        lastElement = this.detailsSection(background, lastElement, (Constraint)left, (Constraint)right);
    }

    private GuiElement<?> configSection(GuiElement<?> background, Constraint left, Constraint right) {
        ConstraintImpl.Relative midPos = Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)90.0);
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.configure").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.server_name")).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, (Constraint)midPos)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton randomise = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237115_((String)"minetogether:gui.order.button.randomize")).onPress(() -> this.nameField.setValue(OrderGui.getDefaultName())).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)70.0));
        GuiElement nameBackground = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(background).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)midPos)).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)randomise.get(GeoParam.LEFT), (double)-2.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)nameBackground).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)nameBackground);
        Pattern namePattern = Pattern.compile("([A-Za-z0-9]*)");
        this.nameField = new GuiTextField((GuiParent)nameBackground).setTextState(TextState.create(() -> this.order.name, s -> {
            this.order.name = s;
            this.nameDirty();
        })).setMaxLength(16).setFilter(s -> s.isEmpty() || namePattern.matcher((CharSequence)s).matches());
        Constraints.bind((ConstrainedGeometry)this.nameField, (ConstrainedGeometry)nameBackground, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        highlight.setEnabled(() -> ((GuiTextField)this.nameField).isFocused());
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.player_count")).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, (Constraint)midPos)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        for (int i = 0; i < 5; ++i) {
            int finalI = i;
            int count = 5 + i * 5;
            ((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237113_((String)String.valueOf(count))).setToggleMode(() -> this.order.playerAmount == count).onPress(() -> {
                this.order.playerAmount = count;
                this.dataCenterAvailability.clear();
                this.updateLocations();
                this.summaryDirty();
            }).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> OrderGui.lambda$configSection$13((Constraint)midPos, right, finalI)).precise())).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> OrderGui.lambda$configSection$14(right, (Constraint)midPos)).precise());
        }
        MutableComponent playerCountInfo = Component.m_237115_((String)"minetogether:gui.order.player_count.info").m_130940_(ChatFormatting.GRAY);
        lastElement = (GuiElement)((GuiText)((GuiText)new GuiText(background, (Component)playerCountInfo).setWrap(true).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right);
        lastElement.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> OrderGui.lambda$configSection$15(background, (Component)playerCountInfo, right, left)));
        return lastElement;
    }

    private GuiElement<?> locationSection(GuiElement<?> background, GuiElement<?> lastElement, Constraint left, Constraint right) {
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.location").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = this.locations = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement(background).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText locationLoading = new GuiText(this.locations, (Component)Component.m_237115_((String)"minetogether:gui.order.loading_locations").m_130940_(ChatFormatting.YELLOW)).setAlignment(Align.LEFT);
        Constraints.bind((ConstrainedGeometry)locationLoading, this.locations);
        MutableComponent pingInfo = Component.m_237115_((String)"minetogether:gui.order.region.signal").m_130940_(ChatFormatting.GRAY);
        lastElement = (GuiElement)((GuiText)((GuiText)new GuiText(background, (Component)pingInfo).setWrap(true).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right);
        lastElement.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> OrderGui.lambda$locationSection$16(background, (Component)pingInfo, right, left)));
        return lastElement;
    }

    private void updateLocations() {
        this.locations.getChildren().forEach(arg_0 -> this.locations.removeChild(arg_0));
        if (this.regionPing.isEmpty()) {
            this.locations.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            GuiText error = new GuiText(this.locations, (Component)Component.m_237115_((String)"minetogether:gui.order.loading_locations_fail").m_130940_(ChatFormatting.RED)).setAlignment(Align.LEFT);
            Constraints.bind((ConstrainedGeometry)error, this.locations);
        } else {
            ArrayList<String> regionOrder = new ArrayList<String>(this.regionPing.keySet());
            regionOrder.sort(Comparator.comparingDouble(region -> this.regionPing.get(region) < 0 ? 5000.0 : (double)(this.regionPing.get(region) + (this.getAvailability((String)region) ? 0 : 5000))));
            GuiElement element = null;
            for (String region2 : regionOrder) {
                element = (GuiElement)((GuiElement)((GuiElement)this.locationButton(this.locations, region2).constrain(GeoParam.TOP, (Constraint)(element == null ? Constraint.match((GeoRef)this.locations.get(GeoParam.TOP)) : Constraint.relative((GeoRef)element.get(GeoParam.BOTTOM), (double)1.0)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.locations.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.locations.get(GeoParam.RIGHT)));
            }
            if (element != null) {
                this.locations.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)element.get(GeoParam.BOTTOM)));
            }
        }
    }

    private GuiElement<?> detailsSection(GuiElement<?> background, GuiElement<?> lastElement, Constraint left, Constraint right) {
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.details").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        ConstraintImpl.MidPoint centerLeft = Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)-1.0);
        ConstraintImpl.MidPoint centerRight = Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)1.0);
        GuiElement email = (GuiElement)this.emailBox(background, left, right).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement password = (GuiElement)this.passwordBox(background, left, (Constraint)centerLeft, TextState.create(() -> this.order.password, val -> {
            this.order.password = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.password")).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement password2 = (GuiElement)this.passwordBox(background, (Constraint)centerRight, right, TextState.create(() -> this.confirmPassword, val -> {
            this.confirmPassword = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.password_confirm")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement firstName = (GuiElement)this.detailsBox(background, left, (Constraint)centerLeft, TextState.create(() -> this.order.firstName, val -> {
            this.order.firstName = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.first_name")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)password.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement lastName = (GuiElement)this.detailsBox(background, (Constraint)centerRight, right, TextState.create(() -> this.order.lastName, val -> {
            this.order.lastName = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.last_name")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)password.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement address = (GuiElement)this.detailsBox(background, left, (Constraint)centerLeft, TextState.create(() -> this.order.address, val -> {
            this.order.address = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.address")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)firstName.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement city = (GuiElement)this.detailsBox(background, (Constraint)centerRight, right, TextState.create(() -> this.order.city, val -> {
            this.order.city = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.city")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)firstName.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement zipCode = (GuiElement)this.detailsBox(background, left, (Constraint)centerLeft, TextState.create(() -> this.order.zip, val -> {
            this.order.zip = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.zip")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)address.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement state = (GuiElement)this.detailsBox(background, (Constraint)centerRight, right, TextState.create(() -> this.order.state, val -> {
            this.order.state = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.state")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)address.get(GeoParam.BOTTOM), (double)4.0));
        Map<String, Country> countryMap = this.getCountries();
        GuiButton country = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, () -> Component.m_237113_((String)this.getSelectedCountry().toString())).setEnabled(() -> !this.loginMode)).onPress(() -> new ItemSelectDialog<Country>((GuiParent<?>)background.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:gui.order.select_country"), new ArrayList(countryMap.values()), (Country)countryMap.get(this.order.country)).setOnItemSelected(item -> {
            this.order.country = item.key;
            this.summaryDirty();
        })).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)zipCode.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, (Constraint)centerLeft)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiElement phone = (GuiElement)this.detailsBox(background, (Constraint)centerRight, right, TextState.create(() -> this.order.phone, val -> {
            this.order.phone = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.phone")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)zipCode.get(GeoParam.BOTTOM), (double)4.0));
        GuiButton login = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237115_((String)"minetogether:gui.button.login")).setEnabled(() -> this.loginMode)).onPress(this::doLogin).setDisabled(() -> this.order.password.isEmpty() || this.loggingIn || this.loggedIn).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)centerRight)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237119_()).setEnabled(() -> this.loginMode)).setWrap(true).setTextSupplier(() -> {
            if (this.loggingIn) {
                return Component.m_237115_((String)"minetogether:gui.order.logging_in");
            }
            if (this.loggedIn) {
                return Component.m_237115_((String)"minetogether:gui.order.login_success");
            }
            if (!this.loggingInError.isEmpty()) {
                return Component.m_237110_((String)"minetogether:gui.order.login_error", (Object[])new Object[]{this.loggingInError});
            }
            return Component.m_237115_((String)"minetogether:gui.order.account_exists");
        }).setAlignment(Align.CENTER).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)login.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)30.0));
        return lastElement;
    }

    private void setupSummaryPanel(GuiElement<?> background) {
        ConstraintImpl.Relative left = Constraint.match((GeoRef)background.get(GeoParam.LEFT));
        ConstraintImpl.Relative right = Constraint.match((GeoRef)background.get(GeoParam.RIGHT));
        GuiScrolling scrollArea = new GuiScrolling(background);
        GuiElement scrollPane = scrollArea.getContentElement();
        scrollPane.constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)scrollArea.get(GeoParam.RIGHT)));
        Constraints.bind((ConstrainedGeometry)scrollArea, background);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(background, Axis.Y);
        ((GuiSlider)scrollBar.primary).setSliderState(scrollArea.scrollState(Axis.Y)).setScrollableElement((GuiElement)scrollArea);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> scrollArea.hiddenSize(Axis.Y) > 0.0).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)scrollPane.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237113_((String)this.summary.summaryError).m_130940_(ChatFormatting.YELLOW)).setEnabled(() -> !this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = ((GuiTextList)((GuiTextList)((GuiTextList)((GuiTextList)new GuiTextList((GuiParent)scrollPane, () -> this.summary.serverFeatures.stream().map(Component::m_237113_).toList()).setScroll(false).setLineSpacing(1).setVerticalAlign(Align.CENTER).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.location")).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237115_((String)("minetogether:gui.order.region." + this.order.serverLocation))).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.plan")).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, () -> Component.m_237113_((String)this.summary.serverHostName)).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.features")).setEnabled(() -> this.summary.summaryError.isEmpty())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        for (int i = 1; i < 6; ++i) {
            lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)("minetogether:gui.order.summary.feature" + i))).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)(i == 1 ? 2.0 : 1.0)))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        }
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for")).setEnabled(() -> this.summary.summaryError.isEmpty())).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for_details1")).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.paying_for_details2")).setEnabled(() -> this.summary.summaryError.isEmpty())).setTextColour(ChatFormatting.GREEN.m_126665_().intValue()).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
        lastElement = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)scrollPane, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.cancel_any_time")).setEnabled(() -> this.summary.summaryError.isEmpty())).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)left)).constrain(GeoParam.RIGHT, (Constraint)right)).autoHeight();
    }

    private void setupPricePanel(GuiElement<?> background) {
        background.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> 22.0 + (double)(this.summary.tax != 0.0 ? 10 : 0) + (double)(this.summary.discount != 0.0 ? 10 : 0)));
        GuiText total = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.total")).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0));
        GuiText totalValue = new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.total) + " " + this.summary.suffix))).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)totalValue, (ConstrainedGeometry)total);
        GuiText tax = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.tax")).setEnabled(() -> this.summary.tax != 0.0)).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)total.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.summary.tax != 0.0 ? 10.0 : 0.0));
        GuiText taxValue = ((GuiText)new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.tax) + " " + this.summary.suffix))).setEnabled(() -> this.summary.tax != 0.0)).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)taxValue, (ConstrainedGeometry)tax);
        GuiText discount = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.discount")).setEnabled(() -> this.summary.discount != 0.0)).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)tax.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.summary.discount != 0.0 ? 10.0 : 0.0));
        GuiText discountValue = ((GuiText)new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.discount) + " " + this.summary.suffix))).setEnabled(() -> this.summary.discount != 0.0)).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)discountValue, (ConstrainedGeometry)discount);
        GuiText subTotal = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.m_237115_((String)"minetogether:gui.order.summary.sub_total")).setAlignment(Align.LEFT).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)discount.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)10.0));
        GuiText subTotalValue = new GuiText(background, () -> Component.m_237113_((String)(this.summary.prefix + String.format("%.2f", this.summary.subTotal) + " " + this.summary.suffix))).setAlignment(Align.RIGHT);
        Constraints.bind((ConstrainedGeometry)subTotalValue, (ConstrainedGeometry)subTotal);
    }

    private void buildProcessingScreen(GuiElement<?> root) {
        GuiRectangle background = ((GuiRectangle)((GuiRectangle)new GuiRectangle(root).setEnabled(() -> this.processing)).setOpaque(true)).fill(-536870912);
        Constraints.bind((ConstrainedGeometry)background, root);
        GuiText textList = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> this.processingText).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.TOP), (GeoRef)background.get(GeoParam.BOTTOM), (double)-5.0))).autoHeight();
        this.processingButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237119_()).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)-50.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.LEFT), (GeoRef)background.get(GeoParam.RIGHT), (double)50.0))).constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)background.get(GeoParam.TOP), (GeoRef)background.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(background, (Component)Component.m_237115_((String)"minetogether:gui.button.close")).setEnabled(() -> this.processingShowCloseButton)).onPress(() -> root.getModularGui().getScreen().m_7379_()).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.processingButton.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.processingButton.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.processingButton.get(GeoParam.BOTTOM), (double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
    }

    private void setProcessing(@Nullable Component buttonText, @Nullable Runnable action, Component text) {
        this.processing = true;
        this.processingButton.setEnabled(buttonText != null && action != null);
        if (this.processingButton.isEnabled()) {
            this.processingButton.getLabel().setText(buttonText);
            this.processingButton.onPress(action);
        }
        this.processingText = text;
    }

    private void clearProcessing() {
        this.processing = false;
    }

    private GuiElement<?> locationButton(GuiElement<?> parent, String region) {
        boolean available = this.getAvailability(region);
        GuiButton button = (GuiButton)MTStyle.Flat.button(parent, (Supplier<Component>)null).setToggleMode(() -> region.equals(this.order.serverLocation)).onPress(() -> {
            this.order.serverLocation = region;
            this.summaryDirty();
        }).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(available ? 12.0 : 32.0)));
        GuiText label = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)Component.m_237115_((String)("minetogether:gui.order.region." + region))).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.RIGHT), (double)-14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        double ping = this.regionPing.getOrDefault(region, -2).intValue();
        int distance = this.dataCenterDistance.getOrDefault(this.regionToDataCentre(region), -1);
        GuiText pingLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)Component.m_237113_((String)((int)Math.ceil(ping) + " ms"))).setEnabled(() -> ping > 0.0)).setAlignment(Align.RIGHT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.RIGHT), (double)-14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiTexture signal = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)button, MTTextures.getter(() -> this.getSignalIcon(ping, distance))).setTooltipSingle(() -> this.getSignalTooltip(ping, distance))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)12.0));
        if (!available) {
            GuiText lowAvail = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)Component.m_237115_((String)"minetogether:gui.order.low_availability").m_130940_(ChatFormatting.RED)).setAlignment(Align.LEFT).setWrap(true).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.RIGHT), (double)-4.0))).autoHeight();
            button.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> 12.0 + lowAvail.ySize() + 4.0));
        }
        return button;
    }

    private GuiElement<?> emailBox(GuiElement<?> parent, Constraint left, Constraint right) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(parent).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion((Component)Component.m_237115_((String)"minetogether.info.e_mail")).setTextState(TextState.create(() -> this.order.emailAddress, s -> {
            this.order.emailAddress = s;
            this.emailDirty();
        }));
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private GuiElement<?> passwordBox(GuiElement<?> parent, Constraint left, Constraint right, TextState textState, Component suggestion) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(parent).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion(suggestion).setFormatter((s, integer) -> Component.m_237113_((String)StringUtils.repeat((char)'*', (int)s.length())).m_7532_()).setTextState(textState);
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private GuiElement<?> detailsBox(GuiElement<?> parent, Constraint left, Constraint right, TextState textState, Component suggestion) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(parent).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion(suggestion).setTextState(textState);
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private void validateInputs() {
        this.inputsValid = false;
        if (!this.nameValid) {
            this.invalidMessage = this.nameMessage;
        } else if (!this.emailValid) {
            this.invalidMessage = this.emailMessage;
        } else if (!this.loginMode && !this.confirmPassword.equals(this.order.password)) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.passwords_dont_match");
        } else if (this.order.password.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.password");
        } else if (!this.loginMode && this.order.firstName.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.first_name");
        } else if (!this.loginMode && this.order.lastName.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.last_name");
        } else if (!this.loginMode && this.order.address.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.address");
        } else if (!this.loginMode && this.order.city.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.city");
        } else if (!this.loginMode && this.order.zip.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.zip");
        } else if (!this.loginMode && this.order.state.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.state");
        } else if (!this.loginMode && this.order.phone.isEmpty()) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.blank.phone");
        } else if (this.loginMode && !this.loggedIn) {
            this.invalidMessage = Component.m_237115_((String)"minetogether:gui.order.login_required");
        } else {
            this.inputsValid = true;
        }
    }

    public void emailDirty() {
        this.emailValid = false;
        if (!EMAIL_PATTERN.matcher(this.order.emailAddress.toLowerCase()).matches()) {
            this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_invalid");
            return;
        }
        this.emailCheckTimer = 60;
        this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_not_checked");
    }

    private void nameDirty() {
        this.nameValid = false;
        this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.name_not_checked");
        this.nameCheckTimer = 60;
    }

    private void summaryDirty() {
        this.summaryUpdateRequired = true;
    }

    private void doLogin() {
        this.loggingIn = true;
        CompletableFuture.runAsync(() -> {
            String result = ServerOrderCallbacks.doLogin(this.order.emailAddress, this.order.password);
            String[] resultSplit = result.split(":");
            if (resultSplit[0].equals("success")) {
                this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "98874";
                this.loggingIn = false;
                this.loggedIn = true;
                this.loggingInError = "";
                this.summaryDirty();
            } else {
                this.loggingIn = false;
                this.loggedIn = false;
                this.loggingInError = result;
            }
        });
    }

    private void placeOrder(ModularGui gui) {
        if (this.orderTask != null) {
            return;
        }
        this.orderTask = CompletableFuture.runAsync(() -> {
            String[] resultSplit;
            String result;
            if (!this.loginMode) {
                this.setProcessing(null, null, (Component)Component.m_237115_((String)"minetogether:gui.order.account_creating"));
                result = ServerOrderCallbacks.createAccount(this.order);
                resultSplit = result.split(":");
                if (resultSplit[0].equals("success")) {
                    this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                    this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "0";
                } else {
                    this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.ok"), this::clearProcessing, (Component)Component.m_237110_((String)"minetogether:gui.order.account_error", (Object[])new Object[]{result}));
                    return;
                }
            }
            this.setProcessing(null, null, (Component)Component.m_237115_((String)"minetogether:gui.order.order_placing"));
            result = ServerOrderCallbacks.createOrder(this.order, this.getRegionId(this.order.serverLocation), String.valueOf(Config.instance().pregenDiameter));
            resultSplit = result.split(":");
            if (!resultSplit[0].equals("success")) {
                this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.ok"), this::clearProcessing, (Component)Component.m_237110_((String)"minetogether:gui.order.order_error", (Object[])new Object[]{result}));
                return;
            }
            this.invoiceID = resultSplit[1] != null ? resultSplit[1] : "0";
            this.orderNumber = Integer.parseInt(resultSplit[2]);
            this.processingShowCloseButton = true;
            this.setProcessing((Component)Component.m_237115_((String)"minetogether:gui.button.invoice"), () -> {
                try {
                    Util.m_137581_().m_137648_(new URI(ServerOrderCallbacks.getPaymentLink(this.invoiceID)));
                }
                catch (Throwable throwable) {
                    gui.mc().f_91068_.m_90911_(ServerOrderCallbacks.getPaymentLink(this.invoiceID));
                    this.processingText = Component.m_237113_((String)"Something went wrong while attempting to open the link,\nSo the link has been copied to your clipboard.");
                    LOGGER.error("Couldn't open link", throwable);
                }
            }, (Component)Component.m_237115_((String)"minetogether:gui.order.order_success"));
        });
    }

    private void tick(ModularGui gui) {
        if (!this.nameValid && --this.nameCheckTimer == 0) {
            if (this.order.name.isEmpty()) {
                this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.blank.name");
            } else {
                this.nameMessage = Component.m_237115_((String)"minetogether:gui.order.name_checking");
                CompletableFuture.runAsync(() -> {
                    AvailableResult result = ServerOrderCallbacks.getNameAvailable(this.order.name);
                    this.nameValid = result.getSuccess();
                    this.nameMessage = Component.m_237113_((String)result.getMessage());
                });
            }
        }
        if (!this.emailValid && --this.emailCheckTimer == 0) {
            if (this.order.emailAddress.isEmpty()) {
                this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.blank.email");
            } else {
                this.emailMessage = Component.m_237115_((String)"minetogether:gui.order.email_checking");
                CompletableFuture.runAsync(() -> {
                    this.loginMode = ServerOrderCallbacks.doesEmailExist(this.order.emailAddress);
                    this.emailValid = true;
                    this.emailMessage = null;
                });
            }
        }
        if (this.initTask != null && this.initTask.isDone() && this.locations != null) {
            this.initTask = null;
            this.updateLocations();
        }
        if (this.initTask == null && this.pingTask == null && this.pingTimer-- <= 0) {
            this.pingTask = CompletableFuture.runAsync(() -> {
                boolean allDone;
                ArrayList<CompletableFuture<Void>> pingers = new ArrayList<CompletableFuture<Void>>();
                for (String key : this.regionPing.keySet()) {
                    pingers.add(CompletableFuture.runAsync(() -> {
                        String url = this.dataCenterUrls.get(this.regionToDataCentre(key));
                        int distance = this.dataCenterDistance.get(this.regionToDataCentre(key));
                        if (url == null || distance == -1) {
                            this.regionPing.put(key, -2);
                        } else {
                            try {
                                this.regionPing.put(key, ServerOrderCallbacks.getDataCentreLatency(url, distance));
                            }
                            catch (IOException ignored) {
                                this.regionPing.put(key, -2);
                            }
                        }
                        this.pingUpdated = true;
                    }));
                }
                while (!(allDone = pingers.stream().allMatch(CompletableFuture::isDone))) {
                }
                this.pingTimer = 200;
            });
        } else if (this.pingTask != null && this.pingTask.isDone()) {
            this.pingTask = null;
            this.updateLocations();
        }
        if (this.pingUpdated) {
            this.pingUpdated = false;
            this.updateLocations();
        }
        if (this.summaryUpdateRequired && !this.summaryUpdating) {
            this.summaryUpdating = true;
            this.summaryUpdateRequired = false;
            CompletableFuture.runAsync(() -> {
                this.summary = ServerOrderCallbacks.getSummary(this.order, Config.instance().promoCode);
                this.order.productID = this.summary.productID;
                this.order.currency = this.summary.currency;
                this.summaryUpdating = false;
            });
        }
        if (this.dataCenterAvailability.isEmpty() && this.availabilityTask == null && !this.summaryUpdateRequired && !this.summaryUpdating) {
            this.availabilityTask = CompletableFuture.runAsync(() -> this.dataCenterAvailability.putAll(ServerOrderCallbacks.getDataCentreAvailability(this.summary.ram + 4096)));
        } else if (this.availabilityTask != null && this.availabilityTask.isDone()) {
            this.availabilityTask = null;
            this.updateLocations();
        }
        if (this.orderTask != null && this.orderTask.isDone()) {
            this.orderTask = null;
        }
        this.validateInputs();
    }

    private Component getOrderButtonText() {
        if (this.orderTask != null) {
            return Component.m_237115_((String)"minetogether:gui.order.order_in_progress");
        }
        if (this.summaryUpdating || this.summaryUpdateRequired) {
            return Component.m_237115_((String)"minetogether:gui.order.summary.updating");
        }
        if (this.inputsValid) {
            return Component.m_237115_((String)"minetogether:gui.order.place_order");
        }
        return this.invalidMessage == null ? Component.m_237119_() : this.invalidMessage.m_6881_().m_130940_(ChatFormatting.RED);
    }

    private String getSignalIcon(double ping, int distance) {
        if (ping > 0.0) {
            int icon = MathUtil.clamp((int)(5 - (int)(ping / 42.0)), (int)1, (int)5);
            return "signal/signal_" + icon;
        }
        if (distance != -1) {
            if (distance < 1000) {
                return "signal/signal_5";
            }
            if (distance > 1000 && distance < 3000) {
                return "signal/signal_4";
            }
            if (distance > 3000 && distance < 5000) {
                return "signal/signal_3";
            }
            if (distance > 5000 && distance < 6000) {
                return "signal/signal_2";
            }
            return "signal/signal_1";
        }
        if (ping == -1.0) {
            int l = (int)(Util.m_137550_() / 100L & 7L);
            if (l > 4) {
                l = 8 - l;
            }
            return "signal/scan_" + l;
        }
        return "signal/signal_0";
    }

    private Component getSignalTooltip(double ping, int distance) {
        if (ping > 0.0) {
            return Component.m_237115_((String)"minetogether:gui.order.region.signal");
        }
        if (distance > 0) {
            return Component.m_237115_((String)"minetogether:gui.order.region.from_distance");
        }
        if (ping == -1.0) {
            return Component.m_237115_((String)"minetogether:gui.order.region.pinging");
        }
        return Component.m_237115_((String)"minetogether:gui.order.region.pinging_fail");
    }

    private Map<String, Country> getCountries() {
        LinkedHashMap<String, Country> map = new LinkedHashMap<String, Country>();
        Countries.COUNTRIES.forEach((key, name) -> map.put((String)key, new Country((String)key, (String)name)));
        return map;
    }

    private Country getSelectedCountry() {
        return new Country(this.order.country, Countries.COUNTRIES.get(this.order.country));
    }

    private String regionToDataCentre(String region) {
        return switch (region) {
            case "eu-west" -> "grantham";
            case "na-east" -> "newyork";
            case "na-west" -> "losangeles";
            case "na-south" -> "dallas";
            case "sub-saharan-africa" -> "johannesburg";
            case "south-america" -> "saopaulo";
            case "asia" -> "hongkong";
            case "australia" -> "sydney";
            case "eu-middle-east" -> "bucharest";
            default -> "";
        };
    }

    private String datacentreToRegion(String centre) {
        return switch (centre) {
            case "grantham" -> "eu-west";
            case "buffalo" -> "na-east";
            case "chicago" -> "na-east";
            case "miami" -> "na-south";
            case "dallas" -> "na-south";
            case "newyork" -> "na-south";
            case "seattle" -> "na-west";
            case "losangeles" -> "na-west";
            case "johannesburg" -> "sub-saharan-africa";
            case "tokyo" -> "asia";
            case "saopaulo" -> "south-america";
            case "hongkong" -> "asia";
            case "sydney" -> "australia";
            case "bucharest" -> "eu-middle-east";
            default -> "";
        };
    }

    private String getRegionId(String region) {
        return this.regionMap.getOrDefault(region, region);
    }

    private boolean getAvailability(String region) {
        if (this.availabilityTask != null || this.dataCenterAvailability.isEmpty()) {
            return true;
        }
        for (String center : this.dataCenterAvailability.keySet()) {
            if (!this.datacentreToRegion(center).equals(region) || !this.dataCenterAvailability.get(center).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static String getDefaultName() {
        String[] nm1 = new String[]{"amber", "angel", "spirit", "basin", "lagoon", "basin", "arrow", "autumn", "bare", "bay", "beach", "bear", "bell", "black", "bleak", "blind", "bone", "boulder", "bridge", "brine", "brittle", "bronze", "castle", "cave", "chill", "clay", "clear", "cliff", "cloud", "cold", "crag", "crow", "crystal", "curse", "dark", "dawn", "dead", "deep", "deer", "demon", "dew", "dim", "dire", "dirt", "dog", "dragon", "dry", "dusk", "dust", "eagle", "earth", "east", "ebon", "edge", "elder", "ember", "ever", "fair", "fall", "false", "far", "fay", "fear", "flame", "flat", "frey", "frost", "ghost", "glimmer", "gloom", "gold", "grass", "gray", "green", "grim", "grime", "hazel", "heart", "high", "hollow", "honey", "hound", "ice", "iron", "kil", "knight", "lake", "last", "light", "lime", "little", "lost", "mad", "mage", "maple", "mid", "might", "mill", "mist", "moon", "moss", "mud", "mute", "myth", "never", "new", "night", "north", "oaken", "ocean", "old", "ox", "pearl", "pine", "pond", "pure", "quick", "rage", "raven", "red", "rime", "river", "rock", "rogue", "rose", "rust", "salt", "sand", "scorch", "shade", "shadow", "shimmer", "shroud", "silent", "silk", "silver", "sleek", "sleet", "sly", "small", "smooth", "snake", "snow", "south", "spring", "stag", "star", "steam", "steel", "steep", "still", "stone", "storm", "summer", "sun", "swamp", "swan", "swift", "thorn", "timber", "trade", "west", "whale", "whit", "white", "wild", "wilde", "wind", "winter", "wolf"};
        String[] nm2 = new String[]{"acre", "band", "barrow", "bay", "bell", "born", "borough", "bourne", "breach", "break", "brook", "burgh", "burn", "bury", "cairn", "call", "chill", "cliff", "coast", "crest", "cross", "dale", "denn", "drift", "fair", "fall", "falls", "fell", "field", "ford", "forest", "fort", "front", "frost", "garde", "gate", "glen", "grasp", "grave", "grove", "guard", "gulch", "gulf", "hall", "hallow", "ham", "hand", "harbor", "haven", "helm", "hill", "hold", "holde", "hollow", "horn", "host", "keep", "land", "light", "maw", "meadow", "mere", "mire", "mond", "moor", "more", "mount", "mouth", "pass", "peak", "point", "pond", "port", "post", "reach", "rest", "rock", "run", "scar", "shade", "shear", "shell", "shield", "shore", "shire", "side", "spell", "spire", "stall", "wich", "minster", "star", "storm", "strand", "summit", "tide", "town", "vale", "valley", "vault", "vein", "view", "ville", "wall", "wallow", "ward", "watch", "water", "well", "wharf", "wick", "wind", "wood", "yard"};
        int rnd = RAND.nextInt(nm1.length);
        int rnd2 = RAND.nextInt(nm2.length);
        while (Objects.equals(nm1[rnd], nm2[rnd2])) {
            rnd2 = RAND.nextInt(nm2.length);
        }
        return nm1[rnd] + nm2[rnd2] + RAND.nextInt(999);
    }

    private static /* synthetic */ Double lambda$locationSection$16(GuiElement background, Component pingInfo, Constraint right, Constraint left) {
        return background.font().m_239133_((FormattedText)pingInfo, (int)right.get() - (int)left.get());
    }

    private static /* synthetic */ Double lambda$configSection$15(GuiElement background, Component playerCountInfo, Constraint right, Constraint left) {
        return background.font().m_239133_((FormattedText)playerCountInfo, (int)right.get() - (int)left.get());
    }

    private static /* synthetic */ Double lambda$configSection$14(Constraint right, Constraint midPos) {
        return (right.get() + 1.0 - midPos.get()) / 5.0 - 1.0;
    }

    private static /* synthetic */ Double lambda$configSection$13(Constraint midPos, Constraint right, int finalI) {
        return midPos.get() + (right.get() + 1.0 - midPos.get()) / 5.0 * (double)finalI;
    }

    record Country(String key, String name) {
        @Override
        public String toString() {
            return this.name == null ? "" : this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Country country = (Country)o;
            return Objects.equals(this.key, country.key) && Objects.equals(this.name, country.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.name);
        }
    }
}

