/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DropdownButton<E extends DropdownEntry>
extends Button {
    private static final Button.OnPress NONE = e -> {};
    private final List<E> entries = new LinkedList();
    private final List<Runnable> dynamicCallbacks = new LinkedList<Runnable>();
    private final boolean isAnchored;
    private final boolean hasHeader;
    private final Consumer<E> onPressed;
    private boolean isFlipped;
    private boolean dropdownOpen;
    private E selected;
    public boolean wasJustClosed;

    public DropdownButton(int x, int y, boolean hasHeader, Consumer<E> callback) {
        this(x, y, 200, 20, true, hasHeader, callback);
    }

    public DropdownButton(int width, int height, Consumer<E> callback) {
        this(-1000, -1000, width, height, false, false, callback);
    }

    public DropdownButton(int x, int y, int width, int height, boolean isAnchored, boolean hasHeader, Consumer<E> callback) {
        super(x, y, width, height, (Component)Component.m_237119_(), NONE);
        this.isAnchored = isAnchored;
        this.hasHeader = hasHeader;
        this.onPressed = callback;
    }

    public DropdownButton<E> setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
        return this;
    }

    public DropdownButton<E> setSelected(E entry) {
        this.selected = entry;
        this.m_93666_(this.selected.getTitle(false));
        return this;
    }

    @SafeVarargs
    public final DropdownButton<E> setEntries(E ... entries) {
        return this.setEntries((Collection<? extends E>)Arrays.asList(entries));
    }

    public DropdownButton<E> setEntries(Collection<? extends E> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        return this;
    }

    public DropdownButton<E> withDynamicCallback(Runnable callback) {
        this.dynamicCallbacks.add(callback);
        return this;
    }

    public void m_6303_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        int drawY = this.f_93621_;
        Font font = Minecraft.m_91087_().f_91062_;
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= drawY && mouseX < this.f_93620_ + this.f_93618_ && mouseY < drawY + this.f_93619_;
        int i = this.getHoverState(this.f_93622_);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (this.hasHeader) {
            this.m_93228_(pStack, this.f_93620_, drawY, 0, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
            this.m_93228_(pStack, this.f_93620_ + this.f_93618_ / 2, drawY, 200 - this.f_93618_ / 2, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
            int j = 0xE0E0E0;
            if (!this.f_93623_) {
                j = 0xA0A0A0;
            } else if (this.f_93622_) {
                j = 0xFFFFA0;
            }
            DropdownButton.m_93215_((PoseStack)pStack, (Font)font, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)j);
        }
        if (this.dropdownOpen) {
            ++drawY;
            int yOffset = this.f_93619_;
            if (this.isFlipped) {
                yOffset = -yOffset;
                --drawY;
            }
            for (DropdownEntry e : this.entries) {
                boolean ourHovered = mouseX >= this.f_93620_ && mouseY >= (drawY += yOffset) && mouseX < this.f_93620_ + this.f_93618_ && mouseY < drawY + this.f_93619_ - 2;
                int subHovered = ourHovered ? 2 : 0;
                RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.m_93228_(pStack, this.f_93620_, drawY, 0, 46 + subHovered * 20, this.f_93618_ / 2, this.f_93619_);
                this.m_93228_(pStack, this.f_93620_ + this.f_93618_ / 2, drawY, 200 - this.f_93618_ / 2, 46 + subHovered * 20, this.f_93618_ / 2, this.f_93619_);
                int textColour = 0xE0E0E0;
                DropdownButton.m_93215_((PoseStack)pStack, (Font)font, (Component)e.getTitle(true), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(drawY + 1 + (this.f_93619_ - 10) / 2), (int)textColour);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean pressed = super.m_6375_(mouseX, mouseY, button);
        if (this.dropdownOpen) {
            if (this.hasHeader && pressed) {
                this.close();
                return false;
            }
            E clicked = this.getClickedElement(mouseX, mouseY);
            if (clicked != null) {
                this.setSelected(clicked);
                this.onPressed.accept(clicked);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed && this.hasHeader) {
            this.dropdownOpen = true;
            for (Runnable dynamicCallback : this.dynamicCallbacks) {
                dynamicCallback.run();
            }
        }
        return false;
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
        if (!this.isAnchored) {
            this.f_93620_ = -1000;
            this.f_93621_ = -1000;
        }
    }

    public void openAt(double mouseX, double mouseY) {
        if (this.isAnchored) {
            throw new UnsupportedOperationException("Cannot move anchored dropdown.");
        }
        this.f_93620_ = (int)mouseX;
        this.f_93621_ = (int)mouseY;
        boolean bl = this.isFlipped = mouseY > 150.0;
        if (!this.isFlipped) {
            this.f_93621_ -= this.m_93694_() - 1;
            ++this.f_93620_;
        }
        this.dropdownOpen = true;
    }

    private int getHoverState(boolean mouseOver) {
        if (mouseOver) {
            return 2;
        }
        if (!this.f_93623_) {
            return 0;
        }
        return this.dropdownOpen ? 2 : 1;
    }

    private E getClickedElement(double mouseX, double mouseY) {
        DropdownEntry clickedElement = null;
        int y = this.f_93621_ + 1;
        int yOffset = this.f_93619_ - 2;
        if (this.isFlipped) {
            yOffset = -yOffset;
            --y;
        }
        for (DropdownEntry e : this.entries) {
            y += yOffset;
            if (!(mouseX >= (double)this.f_93620_) || !(mouseY >= (double)y) || !(mouseX < (double)(this.f_93620_ + this.f_93618_)) || !(mouseY < (double)(y + this.f_93619_ - 2))) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public static interface DropdownEntry {
        public Component getTitle(boolean var1);
    }
}

