/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class PreviewRenderer
implements Widget {
    private static final Set<String> SUPPORTED_IMAGES = ImmutableSet.of((Object)"image/jpeg", (Object)"image/png", (Object)"image/tga", (Object)"image/psd", (Object)"image/hdr", (Object)"image/pic", (Object[])new String[]{"image/pnm"});
    private static final Set<String> ALLOWED_DOMAINS = ImmutableSet.of((Object)"blockshot.ch");
    private static final boolean DEBUG = Boolean.getBoolean("PreviewRenderer.debug");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private static final ExecutorService PREVIEW_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("preview-render-%d").setDaemon(true).build());
    private static final Set<URL> NO_PREVIEW = Collections.synchronizedSet(new HashSet());
    private static final Cache<URL, Preview> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(e -> {
        if (e.wasEvicted()) {
            try {
                ((Preview)e.getValue()).close();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to close Preview: {}", e.getKey(), (Object)ex);
            }
        }
    }).build();
    private final int xOffset;
    private final int yOffset;
    private final int width;
    private final int height;

    protected PreviewRenderer(int xOffset, int yOffset, int width, int height) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
    }

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        URL url = this.getUrlUnderMouse(mouseX, mouseY);
        if (url == null) {
            return;
        }
        Preview preview = PreviewRenderer.getPreview(url);
        if (preview == null) {
            return;
        }
        preview.render(pStack, mouseX + this.xOffset, mouseY + this.yOffset, this.width, this.height, partialTicks);
    }

    @Nullable
    protected abstract URL getUrlUnderMouse(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Preview getPreview(URL url) {
        if (!ALLOWED_DOMAINS.contains(url.getHost())) {
            return null;
        }
        if (NO_PREVIEW.contains(url)) {
            return null;
        }
        Preview preview = (Preview)CACHE.getIfPresent((Object)url);
        if (preview != null) {
            return preview;
        }
        Cache<URL, Preview> cache = CACHE;
        synchronized (cache) {
            preview = (Preview)CACHE.getIfPresent((Object)url);
            if (preview != null) {
                return preview;
            }
            preview = PreviewRenderer.compute(url);
            CACHE.put((Object)url, (Object)preview);
            return preview;
        }
    }

    private static Preview compute(URL url) {
        LoadingPreview preview = new LoadingPreview();
        PREVIEW_EXECUTOR.execute(() -> PreviewRenderer.load(url, preview));
        return preview;
    }

    private static void load(URL url, LoadingPreview preview) {
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)new HttpGet(url.toURI()));){
            HttpEntity entity = response.getEntity();
            if (entity == null || !SUPPORTED_IMAGES.contains(entity.getContentType().getValue())) {
                if (DEBUG) {
                    LOGGER.info("Ignoring {} for preview, returned content type: {}", (Object)url, entity != null ? entity.getContentType() : "Entity null");
                }
                NO_PREVIEW.add(url);
                return;
            }
            NativeImage image = NativeImage.m_85058_((InputStream)entity.getContent());
            preview.setWrapped(new ImagePreview(image));
        }
        catch (IOException | URISyntaxException ex) {
            LOGGER.error("Failed to load preview for: {}", (Object)url, (Object)ex);
            NO_PREVIEW.add(url);
        }
    }

    private static abstract class Preview
    implements AutoCloseable {
        private Preview() {
        }

        public abstract void render(PoseStack var1, int var2, int var3, int var4, int var5, float var6);
    }

    private static class LoadingPreview
    extends Preview {
        private Preview wrapped;
        public boolean closed;

        @Override
        public void render(PoseStack pStack, int x, int y, int w, int h, float partialTicks) {
            if (this.closed) {
                return;
            }
            if (this.wrapped != null) {
                this.wrapped.render(pStack, x, y, w, h, partialTicks);
            }
        }

        public void setWrapped(Preview wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
            if (this.wrapped != null) {
                this.wrapped.close();
            }
        }
    }

    private static class ImagePreview
    extends Preview {
        private final NativeImage image;
        private int glTexture = -1;

        private ImagePreview(NativeImage image) {
            this.image = image;
        }

        @Override
        public void render(PoseStack pStack, int x, int y, int w, int h, float partialTicks) {
            if (this.glTexture == -1) {
                this.glTexture = TextureUtil.m_85280_();
                TextureUtil.m_85287_((int)this.glTexture, (int)0, (int)this.image.m_84982_(), (int)this.image.m_85084_());
                this.image.m_85003_(0, 0, 0, 0, 0, this.image.m_84982_(), this.image.m_85084_(), false, true);
            }
            RenderSystem.m_69493_();
            RenderSystem.m_157453_((int)0, (int)this.glTexture);
            GuiComponent.m_93133_((PoseStack)pStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        }

        @Override
        public void close() throws Exception {
            TextureUtil.m_85281_((int)this.glTexture);
            this.glTexture = -1;
            this.image.close();
        }
    }
}

