/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.google.code.gson:gson")
public class JsonUtils {
    private static final Gson GSON = new Gson();

    public static <T> T parse(Gson gson, Path path, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, Files.newInputStream(path, new OpenOption[0]), t);
    }

    public static <T> T parse(Gson gson, String str, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, new StringReader(str), t);
    }

    public static <T> T parse(Gson gson, InputStream is, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, new InputStreamReader(is), t);
    }

    public static <T> T parse(Gson gson, Reader reader, Type t) throws IOException, JsonParseException {
        try (Reader r = reader;){
            Object object = gson.fromJson(r, t);
            return (T)object;
        }
    }

    public static JsonElement parseRaw(Path path) throws IOException, JsonParseException {
        return JsonUtils.parseRaw(Files.newInputStream(path, new OpenOption[0]));
    }

    public static JsonElement parseRaw(String str) throws IOException, JsonParseException {
        return JsonUtils.parseRaw(new StringReader(str));
    }

    public static JsonElement parseRaw(InputStream is) throws IOException, JsonParseException {
        return JsonUtils.parseRaw(new InputStreamReader(is));
    }

    public static JsonElement parseRaw(Reader reader) throws IOException, JsonParseException {
        try (Reader r = reader;){
            JsonElement jsonElement = (JsonElement)GSON.fromJson(r, JsonElement.class);
            return jsonElement;
        }
    }

    public static void write(Gson gson, Path path, Object instance) throws IOException, JsonIOException {
        JsonUtils.write(gson, path, instance, instance.getClass());
    }

    public static void write(Gson gson, Path path, Object instance, Type t) throws IOException, JsonIOException {
        JsonUtils.write(gson, Files.newOutputStream(path, new OpenOption[0]), instance, t);
    }

    public static void write(Gson gson, OutputStream os, Object instance) throws IOException, JsonIOException {
        JsonUtils.write(gson, os, instance, instance.getClass());
    }

    public static void write(Gson gson, OutputStream os, Object instance, Type t) throws IOException, JsonIOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os);){
            gson.toJson(instance, t, (Appendable)writer);
        }
    }

    public static JsonPrimitive getAsPrimitive(JsonObject obj, String key) throws JsonParseException {
        JsonElement element = obj.get(key);
        if (element == null) {
            throw new JsonParseException("Did not find child '" + key + "'. '" + obj + "'");
        }
        if (!element.isJsonPrimitive()) {
            throw new JsonParseException("Expected Json Primitive. Got: '" + element + "'");
        }
        return element.getAsJsonPrimitive();
    }

    @Nullable
    public static JsonPrimitive getAsPrimitiveOrNull(JsonObject obj, String key) {
        JsonElement element = obj.get(key);
        if (element == null) {
            return null;
        }
        if (!element.isJsonPrimitive()) {
            return null;
        }
        return element.getAsJsonPrimitive();
    }

    public static int getInt(JsonObject obj, String key) throws JsonParseException {
        JsonPrimitive prim = JsonUtils.getAsPrimitive(obj, key);
        if (!prim.isNumber()) {
            throw new JsonParseException("Expected Number. Got: '" + prim + "'");
        }
        return prim.getAsInt();
    }

    public static int getInt(JsonObject obj, String key, int default_) {
        JsonPrimitive prim = JsonUtils.getAsPrimitiveOrNull(obj, key);
        if (prim == null) {
            return default_;
        }
        if (!prim.isNumber()) {
            return default_;
        }
        return prim.getAsInt();
    }

    public static String getString(JsonObject obj, String key) throws JsonParseException {
        JsonPrimitive prim = JsonUtils.getAsPrimitive(obj, key);
        if (!prim.isString()) {
            throw new JsonParseException("Expected String. Got: '" + prim + "'");
        }
        return prim.getAsString();
    }

    @Nullable
    @Contract(value="_,_,!null->!null")
    public static String getString(JsonObject obj, String key, @Nullable String default_) {
        JsonPrimitive prim = JsonUtils.getAsPrimitiveOrNull(obj, key);
        if (prim == null) {
            return default_;
        }
        if (!prim.isString()) {
            return default_;
        }
        return prim.getAsString();
    }
}

