/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import net.creeperhost.minetogether.repack.org.pircbotx.Configuration;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.StaticReadonlyDelay;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.ListenerAdapter;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.GenericListenerManager;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.ListenerManager;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericMessageEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplayServer {
    private static final Logger log = LogManager.getLogger(ReplayServer.class);

    public static void main(String[] args) throws Exception {
        try {
            if (args.length != 1 || args[0].trim().length() == 0) {
                System.out.println("Usage: org.pircbotx.impl.ReplayServer [log]");
                System.exit(1);
            }
            File file = new File(args[0].trim());
            ReplayServer.replayFile(file);
        }
        catch (Exception t) {
            if (PircBotX.DEBUG_LEVEL != null) {
                log.log(PircBotX.DEBUG_LEVEL, "Caught exception in main, closing", (Throwable)t);
            }
            System.exit(3);
        }
    }

    public static void replayFile(File file) throws Exception {
        ReplayServer.replayFile(file, ReplayServer.generateConfig());
    }

    public static void replayFile(File file, Configuration.Builder config) throws Exception {
        if (!file.exists()) {
            throw new IOException("File " + file + " does not exist");
        }
        FileInputStream fileInput = new FileInputStream(file);
        try {
            ReplayServer.replay(config, fileInput, "file " + file.getCanonicalPath());
        }
        finally {
            if (Collections.singletonList(fileInput).get(0) != null) {
                fileInput.close();
            }
        }
    }

    public static Configuration.Builder generateConfig() {
        return new Configuration.Builder().setName("QuackPirc").setLogin("QP").addServer("example.com").setNickservPassword(System.getProperty("nickserv")).setMessageDelay(new StaticReadonlyDelay(0L)).setListenerManager(new GenericListenerManager()).setShutdownHookEnabled(false);
    }

    public static void replay(Configuration.Builder config, InputStream input, String title) throws Exception {
        if (PircBotX.INFO_LEVEL != null) {
            log.log(PircBotX.INFO_LEVEL, "---Replaying {}---", (Object)title);
        }
        StopWatch timer = new StopWatch();
        timer.start();
        LinkedList<Event> eventQueue = new LinkedList<Event>();
        WrapperListenerManager newManager = new WrapperListenerManager((ListenerManager)config.getListenerManager(), (Queue<Event>)eventQueue);
        config.setListenerManager(newManager);
        config.addListener(new ReplayListener());
        LinkedList<String> outputQueue = new LinkedList<String>();
        ReplayPircBotX bot = new ReplayPircBotX(config.buildConfiguration(), outputQueue);
        BufferedReader fileInput = new BufferedReader(new InputStreamReader(input));
        boolean skippedHeader = false;
        while (true) {
            String lineRaw = fileInput.readLine();
            if (bot.isClosed() && StringUtils.isNotBlank((CharSequence)lineRaw)) {
                throw new RuntimeException("bot is closed but file still has line " + lineRaw);
            }
            if (!bot.isClosed() && StringUtils.isBlank((CharSequence)lineRaw)) {
                throw new RuntimeException("bot is not closed but file doesn't have any more lines");
            }
            if (bot.isClosed() && StringUtils.isBlank((CharSequence)lineRaw)) {
                if (PircBotX.DEBUG_LEVEL == null) break;
                log.log(PircBotX.DEBUG_LEVEL, "(done) Bot is closed and file doesn't have any more lines");
                break;
            }
            if (PircBotX.DEBUG_LEVEL != null) {
                log.log(PircBotX.DEBUG_LEVEL, "(line) " + lineRaw);
            }
            String[] lineParts = StringUtils.split((String)lineRaw, (String)" ", (int)2);
            String command = lineParts[0];
            String line = lineParts[1];
            if (!skippedHeader) {
                if (command.equals("pircbotx.output")) continue;
                if (command.equals("pircbotx.input")) {
                    if (PircBotX.DEBUG_LEVEL != null) {
                        log.log(PircBotX.DEBUG_LEVEL, "Finished skipping header");
                    }
                    skippedHeader = true;
                } else {
                    throw new RuntimeException("Unknown line " + lineRaw);
                }
            }
            if (command.equals("pircbotx.input")) {
                bot.getInputParser().handleLine(line);
            } else if (command.equals("pircbotx.output")) {
                String lastOutput;
                String string = lastOutput = outputQueue.isEmpty() ? null : outputQueue.pop();
                if (StringUtils.startsWith((CharSequence)line, (CharSequence)"JOIN")) {
                    if (PircBotX.DEBUG_LEVEL != null) {
                        log.log(PircBotX.DEBUG_LEVEL, "Skipping JOIN output, server should send its own JOIN");
                    }
                } else if (StringUtils.startsWith((CharSequence)line, (CharSequence)"QUIT")) {
                    if (PircBotX.DEBUG_LEVEL != null) {
                        log.log(PircBotX.DEBUG_LEVEL, "Skipping QUIT output, server should send its own QUIT");
                    }
                } else if (!line.equals(lastOutput)) {
                    log.error("Expected last output: " + line);
                    log.error("Given last output: " + lastOutput);
                    for (String curOutput : outputQueue) {
                        log.error("Queued output: " + curOutput);
                    }
                    throw new RuntimeException("Failed to verify output (see log)");
                }
            } else {
                throw new RuntimeException("Unknown line " + lineRaw);
            }
            for (Event curEvent : Iterables.consumingIterable(eventQueue)) {
                if (PircBotX.DEBUG_LEVEL == null) continue;
                log.log(PircBotX.DEBUG_LEVEL, "(events) " + curEvent);
            }
            if (PircBotX.DEBUG_LEVEL == null) continue;
            log.log(PircBotX.DEBUG_LEVEL, "");
        }
        timer.stop();
        if (PircBotX.DEBUG_LEVEL != null) {
            log.log(PircBotX.DEBUG_LEVEL, "---Replay successful in {}---", (Object)DurationFormatUtils.formatDuration((long)timer.getTime(), (String)"mm'min'ss'sec'SSS'ms'"));
        }
    }

    static class ReplayListener
    extends ListenerAdapter {
        ReplayListener() {
        }

        @Override
        public void onGenericMessage(GenericMessageEvent event) throws Exception {
            if (event.getMessage().startsWith("?dumpusers")) {
                System.out.println("===command dumpusers start===");
                for (User curUser : ((PircBotX)event.getBot()).getUserChannelDao().getAllUsers()) {
                    if (PircBotX.DEBUG_LEVEL == null) continue;
                    log.log(PircBotX.DEBUG_LEVEL, curUser.getNick() + "!" + curUser.getLogin() + "@" + curUser.getHostname() + " - " + curUser.getHostmask());
                }
                System.out.println("===command dumpusers end===");
            }
        }
    }

    protected static class WrapperListenerManager
    implements ListenerManager {
        private static final Logger log = LogManager.getLogger(WrapperListenerManager.class);
        protected final ListenerManager impl;
        protected final Queue<Event> eventQueue;

        @Override
        public void onEvent(Event event) {
            this.eventQueue.add(event);
            this.impl.onEvent(event);
        }

        public WrapperListenerManager(ListenerManager impl, Queue<Event> eventQueue) {
            this.impl = impl;
            this.eventQueue = eventQueue;
        }

        @Override
        public void addListener(Listener listener) {
            this.impl.addListener(listener);
        }

        @Override
        public boolean removeListener(Listener listener) {
            return this.impl.removeListener(listener);
        }

        @Override
        public boolean listenerExists(Listener listener) {
            return this.impl.listenerExists(listener);
        }

        @Override
        public ImmutableSet<Listener> getListeners() {
            return this.impl.getListeners();
        }

        @Override
        public void shutdown(PircBotX bot) {
            this.impl.shutdown(bot);
        }

        private static interface ImplExclude {
            public void onEvent(Event var1);
        }
    }

    protected static class ReplayPircBotX
    extends PircBotX {
        private static final Logger log = LogManager.getLogger(ReplayPircBotX.class);
        protected final Queue<String> outputQueue;
        protected boolean closed = false;

        public ReplayPircBotX(Configuration configuration, Queue<String> outputQueue) {
            super(configuration);
            this.outputQueue = outputQueue;
        }

        @Override
        protected void sendRawLineToServer(String line) throws IOException {
            this.outputQueue.add(line);
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

