/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.ChannelSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserChannelMapSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserSnapshot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserChannelMap<U extends User, C extends Channel> {
    private static final Logger log = LogManager.getLogger(UserChannelMap.class);
    protected final Multimap<U, C> userToChannelMap;
    protected final Multimap<C, U> channelToUserMap;
    private final ReentrantReadWriteLock reentlock = new ReentrantReadWriteLock();
    private final Lock rL = this.reentlock.readLock();
    private final Lock wL = this.reentlock.writeLock();

    public UserChannelMap() {
        this.channelToUserMap = HashMultimap.create();
        this.userToChannelMap = HashMultimap.create();
    }

    public void addUserToChannel(U user, C channel) {
        this.wL.lock();
        try {
            this.userToChannelMap.put(user, channel);
            this.channelToUserMap.put(channel, user);
        }
        finally {
            this.wL.unlock();
        }
    }

    public void removeUserFromChannel(U user, C channel) {
        this.wL.lock();
        try {
            this.userToChannelMap.remove(user, channel);
            this.channelToUserMap.remove(channel, user);
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(U user) {
        this.wL.lock();
        try {
            for (Channel curChannel : this.userToChannelMap.removeAll(user)) {
                this.channelToUserMap.remove((Object)curChannel, user);
            }
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(C channel) {
        this.wL.lock();
        try {
            for (User curUser : this.channelToUserMap.removeAll(channel)) {
                this.userToChannelMap.remove((Object)curUser, channel);
            }
        }
        finally {
            this.wL.unlock();
        }
    }

    public ImmutableSortedSet<U> getUsers(C channel) {
        this.rL.lock();
        try {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Collection)this.channelToUserMap.get(channel));
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    public ImmutableSortedSet<C> getChannels(U user) {
        this.rL.lock();
        try {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Collection)this.userToChannelMap.get(user));
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntry(U user, C channel) {
        this.rL.lock();
        try {
            boolean channelToUserContains = this.channelToUserMap.containsEntry(channel, user);
            boolean userToChannelContains = this.userToChannelMap.containsEntry(user, channel);
            if (channelToUserContains != userToChannelContains) {
                throw new RuntimeException("Map inconsistent! User: " + user + " | Channel: " + channel + " | channelToUserMap: " + channelToUserContains + " | userToChannelMap: " + userToChannelContains);
            }
            boolean bl = channelToUserContains;
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUser(User user) {
        this.rL.lock();
        try {
            boolean channelToUserContains = this.channelToUserMap.containsValue((Object)user);
            boolean userToChannelContains = this.userToChannelMap.containsKey((Object)user);
            if (channelToUserContains != userToChannelContains) {
                throw new RuntimeException("Map inconsistent! User: " + user + " | channelToUserMap: " + channelToUserContains + " | userToChannelMap: " + userToChannelContains);
            }
            boolean bl = channelToUserContains;
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    public void clear() {
        this.wL.lock();
        try {
            this.userToChannelMap.clear();
            this.channelToUserMap.clear();
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserChannelMapSnapshot createSnapshot(Map<U, UserSnapshot> userSnapshots, Map<C, ChannelSnapshot> channelSnapshots) {
        this.rL.lock();
        try {
            ImmutableMultimap.Builder userToChannelSnapshotBuilder = ImmutableMultimap.builder();
            for (Map.Entry curEntry : this.userToChannelMap.entries()) {
                UserSnapshot key = userSnapshots.get(curEntry.getKey());
                if (key == null) {
                    throw new NullPointerException("Issue #274: No user snapshot for " + curEntry.getKey());
                }
                ChannelSnapshot value = channelSnapshots.get(curEntry.getValue());
                if (value == null) {
                    throw new NullPointerException("Issue #274: No channel snapshot for " + curEntry.getValue());
                }
                userToChannelSnapshotBuilder.put((Object)key, (Object)value);
            }
            ImmutableMultimap.Builder channelToUserSnapshotBuilder = ImmutableMultimap.builder();
            for (Map.Entry curEntry : this.channelToUserMap.entries()) {
                ChannelSnapshot key = channelSnapshots.get(curEntry.getKey());
                if (key == null) {
                    throw new NullPointerException("Issue #274: No channel snapshot for " + curEntry.getKey());
                }
                UserSnapshot value = userSnapshots.get(curEntry.getValue());
                if (value == null) {
                    throw new NullPointerException("Issue #274: No user snapshot for " + curEntry.getValue());
                }
                channelToUserSnapshotBuilder.put((Object)key, (Object)value);
            }
            UserChannelMapSnapshot userChannelMapSnapshot = new UserChannelMapSnapshot((Multimap<UserSnapshot, ChannelSnapshot>)userToChannelSnapshotBuilder.build(), (Multimap<ChannelSnapshot, UserSnapshot>)channelToUserSnapshotBuilder.build());
            return userChannelMapSnapshot;
        }
        finally {
            this.rL.unlock();
        }
    }

    protected UserChannelMap(Multimap<U, C> userToChannelMap, Multimap<C, U> channelToUserMap) {
        this.userToChannelMap = userToChannelMap;
        this.channelToUserMap = channelToUserMap;
    }
}

