/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.cap;

import com.google.common.collect.ImmutableList;
import javax.net.ssl.SSLSocketFactory;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.cap.EnableCapHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.CAPException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TLSCapHandler
extends EnableCapHandler {
    private static final Logger log = LogManager.getLogger(TLSCapHandler.class);
    protected SSLSocketFactory sslSocketFactory;

    public TLSCapHandler() {
        super("tls");
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public TLSCapHandler(SSLSocketFactory sslSocketFactory, boolean ignoreFail) {
        super("tls", ignoreFail);
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public boolean handleACK(PircBotX bot, ImmutableList<String> capabilities) throws CAPException {
        if (capabilities.contains((Object)"tls")) {
            if (PircBotX.DEBUG_LEVEL != null) {
                log.log(PircBotX.DEBUG_LEVEL, "Supported capability tls, sending STARTTLS and awaiting 670 response");
            }
            bot.sendRaw().rawLineNow("STARTTLS");
            return false;
        }
        return false;
    }

    @Override
    public boolean handleUnknown(PircBotX bot, String rawLine) {
        return rawLine.contains(" 670 ");
    }

    @Override
    public String toString() {
        return "TLSCapHandler(sslSocketFactory=" + this.getSslSocketFactory() + ")";
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }
}

