/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.delay;

import com.google.common.base.Preconditions;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.Delay;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.ListenerAdapter;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ServerResponseEvent;

public class AdaptingDelay
extends ListenerAdapter
implements Delay {
    long currentDelay;
    long initialDelay;
    long maxDelay;
    long lastChange;

    public AdaptingDelay(long initialDelay, long maxDelay) {
        Preconditions.checkArgument((maxDelay >= initialDelay ? 1 : 0) != 0, (Object)"initialDelay may not be larger than maxdelay");
        this.setInitialDelay(initialDelay);
        this.setMaxDelay(maxDelay);
        this.currentDelay = initialDelay;
        this.lastChange = System.currentTimeMillis();
    }

    public void setInitialDelay(long initialDelay) {
        Preconditions.checkArgument((initialDelay > 0L ? 1 : 0) != 0, (Object)"initialDelay must be larger than zero");
        this.initialDelay = initialDelay;
    }

    public void setMaxDelay(long maxDelay) {
        Preconditions.checkArgument((maxDelay >= 0L ? 1 : 0) != 0, (Object)"maxDelay may not be negative");
        this.maxDelay = maxDelay;
    }

    public void reset() {
        this.currentDelay = this.initialDelay;
    }

    @Override
    public long getDelay() {
        if (this.currentDelay > this.initialDelay && this.lastChange + 10000L < System.currentTimeMillis()) {
            this.currentDelay = Math.max(this.currentDelay / 2L, this.initialDelay);
            this.lastChange = System.currentTimeMillis();
        }
        return this.currentDelay;
    }

    @Override
    public void onServerResponse(ServerResponseEvent event) throws Exception {
        if (event.getCode() == 439) {
            this.currentDelay = Math.min(this.currentDelay * 2L, this.maxDelay);
            this.lastChange = System.currentTimeMillis();
        }
    }
}

