/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.data;

import java.util.Comparator;
import java.util.Locale;
import net.creeperhost.minetogether.polylib.gui.DropdownButton;
import net.creeperhost.minetogether.serverlist.gui.ServerDataPublic;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.minetogether.util.EnumFlag;
import net.minecraft.network.chat.Component;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SortType implements DropdownButton.DropdownEntry,
Comparator<ServerDataPublic>
{
    RANDOM{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            return 0;
        }
    }
    ,
    PLAYER{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            int o2Players;
            int o1Players = o1.f_105370_ != null ? o1.f_105370_.size() : 0;
            int n = o2Players = o2.f_105370_ != null ? o2.f_105370_.size() : 0;
            return o1Players > o2.server.expectedPlayers ? -1 : (o1Players < o2Players ? 1 : 0);
        }
    }
    ,
    NAME{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            int ret = o1.f_105362_.compareToIgnoreCase(o2.f_105362_);
            return ret == 0 ? o1.f_105362_.compareTo(o2.f_105362_) : ret;
        }
    }
    ,
    UPTIME{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            return Long.compare(o1.server.uptime, o2.server.uptime);
        }
    }
    ,
    LOCATION{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            EnumFlag f2;
            EnumFlag f1 = o1.server.getFlag();
            if (f1 == (f2 = o2.server.getFlag())) {
                return 0;
            }
            if (f1.name().equals(Countries.getOurCountry())) {
                return f2.name().equals(Countries.getOurCountry()) ? 1 : -1;
            }
            if (f2.name().equals(Countries.getOurCountry())) {
                return f1.name().equals(Countries.getOurCountry()) ? -1 : 1;
            }
            int ret = f1.name().compareToIgnoreCase(f2.name());
            return ret == 0 ? f1.name().compareTo(f2.name()) : ret;
        }
    }
    ,
    PING{

        @Override
        public int compare(ServerDataPublic o1, ServerDataPublic o2) {
            if (o1.f_105366_ == o2.f_105366_) {
                return 0;
            }
            if (o1.f_105366_ <= 0L) {
                return 1;
            }
            if (o2.f_105366_ <= 0L) {
                return -1;
            }
            return Long.compare(o1.f_105366_, o2.f_105366_);
        }
    };


    @Override
    public Component getTitle(boolean isOpen) {
        return Component.m_237115_((String)("minetogether:screen.multiplayer.sort." + this.name().toLowerCase(Locale.ROOT)));
    }

    public Component translate() {
        return Component.m_237115_((String)("minetogether:gui.server_list.sort." + this.name().toLowerCase(Locale.ROOT)));
    }
}

