/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import java.nio.file.Path;
import net.creeperhost.minetogether.util.LoggerNameStartsWithFilter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4jUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void attachMTLogs(Path logsFolder) {
        Object logsPath = logsFolder.toString();
        if (!((String)logsPath).endsWith("/")) {
            logsPath = (String)logsPath + "/";
        }
        logsPath = (String)logsPath + "minetogether/";
        try {
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            Configuration configuration = ctx.getConfiguration();
            RollingRandomAccessFileAppender latest = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withName("MT-Latest")).withFilePattern((String)logsPath + "%d{yyyy-MM-dd}-%i.log.gz").withFileName((String)logsPath + "latest.log").withLayout((Layout)PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss}] [%t/%level] [%logger]: %msg%n").build())).withPolicy((TriggeringPolicy)CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{new TimeBasedTriggeringPolicy.Builder().build(), OnStartupTriggeringPolicy.createPolicy((long)1L)})).build();
            RollingRandomAccessFileAppender debug = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withName("MT-Debug")).withFilePattern((String)logsPath + "debug-%i.log.gz").withFileName((String)logsPath + "debug.log").withLayout((Layout)PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss.SSS}] [%t/%level] [%logger]: %msg%n").build())).withPolicy((TriggeringPolicy)CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{OnStartupTriggeringPolicy.createPolicy((long)1L), SizeBasedTriggeringPolicy.createPolicy((String)"200MB")})).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax("5").withFileIndex("min").build()).build();
            latest.start();
            debug.start();
            configuration.addAppender((Appender)latest);
            configuration.addAppender((Appender)debug);
            configuration.getRootLogger().addAppender((Appender)latest, Level.INFO, (Filter)new LoggerNameStartsWithFilter("net.creeperhost.minetogether", Filter.Result.ACCEPT, Filter.Result.DENY));
            configuration.getRootLogger().addAppender((Appender)debug, Level.ALL, (Filter)new LoggerNameStartsWithFilter("net.creeperhost.minetogether", Filter.Result.ACCEPT, Filter.Result.DENY));
            ctx.updateLoggers();
        }
        catch (Throwable ex) {
            LOGGER.error("Unable to configure MineTogether Logging.", ex);
        }
    }
}

