/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.repack.net.covers1624.quack.gson.JsonUtils;
import net.creeperhost.minetogether.util.GetCurseForgeVersionRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPackInfo {
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("mt-packinfo-request").setDaemon(true).build());
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static CompletableFuture<VersionInfo> initTask;

    public static void init() {
        initTask = CompletableFuture.supplyAsync(() -> new VersionInfo().init(), EXECUTOR);
    }

    public static VersionInfo getInfo() {
        try {
            return initTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Failed to retrieve version data", (Throwable)e);
            return new VersionInfo();
        }
    }

    public static void waitForInfo(Consumer<VersionInfo> callback) {
        initTask.thenAccept((Consumer)callback);
    }

    public static class VersionInfo {
        public String curseID;
        public String base64FTBID;
        public String ftbPackID;
        public String realName;

        public VersionInfo() {
            this.curseID = StringUtils.stripToEmpty((String)Config.instance().curseProjectID);
            this.base64FTBID = "";
            this.ftbPackID = "";
            this.realName = "{\"p\": \"-1\"}";
        }

        public VersionInfo init() {
            this.readVersionJson();
            HashMap<String, String> json = new HashMap<String, String>();
            if (this.ftbPackID.isEmpty()) {
                json.put("p", NumberUtils.isParsable((String)this.curseID) ? this.curseID : "-1");
            } else {
                json.put("p", this.ftbPackID);
                json.put("b", this.base64FTBID);
            }
            this.realName = GSON.toJson(json);
            return this;
        }

        private void readVersionJson() {
            Path versionJson = Platform.getGameFolder().resolve("version.json");
            if (Files.exists(versionJson, new LinkOption[0])) {
                try {
                    ModpackVersionManifest manifest = (ModpackVersionManifest)JsonUtils.parse(GSON, versionJson, ModpackVersionManifest.class);
                    this.base64FTBID = Base64.getEncoder().encodeToString((String.valueOf(manifest.parent) + manifest.id).getBytes(StandardCharsets.UTF_8));
                    String resolvedID = MineTogether.API.execute(new GetCurseForgeVersionRequest((String)this.base64FTBID)).apiResponse().id;
                    if (resolvedID.isEmpty()) {
                        resolvedID = "-1";
                    }
                    this.curseID = resolvedID;
                    Config.instance().curseProjectID = resolvedID;
                    Config.save();
                    this.ftbPackID = "m" + manifest.parent;
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to load version manifest.", (Throwable)ex);
                }
            }
        }
    }

    public static class ModpackVersionManifest {
        public long id;
        public long parent;
    }
}

