/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class RenderTexture<T extends Entity>
extends EntityRenderer<T> {
    public final float xSize;
    public final float ySize;
    public final int rows;
    public final int columns;
    public final int length;
    public final float uLength;
    public final float vLength;
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();

    public RenderTexture(EntityRendererProvider.Context ctx, float xSize, float ySize, int rows, int columns) {
        super(ctx);
        this.xSize = xSize;
        this.ySize = ySize;
        this.rows = rows;
        this.columns = columns;
        this.length = rows * columns;
        this.uLength = 1.0f / (float)columns;
        this.vLength = 1.0f / (float)rows;
        this.textureBuilder.setUVLength(this.uLength, this.vLength);
    }

    public void setColor(int hexColor) {
        this.textureBuilder.setColor(hexColor);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.textureBuilder.setColor(red, green, blue, alpha);
    }

    public void m_7392_(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        float yaw = ((Entity)entity).f_19859_ + (entity.m_146908_() - ((Entity)entity).f_19859_) * partialTicks + 180.0f;
        float pitch = ((Entity)entity).f_19860_ + (entity.m_146909_() - ((Entity)entity).f_19860_) * partialTicks;
        if (this.facePlayer()) {
            stack.m_85845_(this.f_114476_.m_114470_());
            stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        } else {
            RenderUtils.applyYawPitch(stack, yaw + this.yawOffset(), pitch + this.pitchOffset());
        }
        float[] uvOffset = this.uvOffset(((Entity)entity).f_19797_);
        this.textureBuilder.setUV(uvOffset[0], uvOffset[1]);
        this.textureBuilder.setLight(packedLight);
        RenderUtils.renderTexture(stack, buffer.m_6299_(this.getRenderType(entity, this.m_5478_((Entity)entity))), this.xSize, this.ySize, this.textureBuilder);
        super.m_7392_(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    protected RenderType getRenderType(T entity, ResourceLocation loc) {
        return RenderType.m_110458_((ResourceLocation)loc);
    }

    public boolean facePlayer() {
        return true;
    }

    public float yawOffset() {
        return 0.0f;
    }

    public float pitchOffset() {
        return 0.0f;
    }

    public float[] uvOffset(int timer) {
        int frame = timer % this.length;
        return new float[]{(float)(frame % this.columns) * this.uLength, (float)frame / (float)this.columns * this.vLength};
    }
}

