/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, Level world, UUID uuid) {
        return (T)EntityUtil.findFromUUID(clss, world, uuid, t -> true);
    }

    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, Level world, UUID uuid, Predicate<T> pred) {
        if (world instanceof ServerLevel) {
            Entity e = ((ServerLevel)world).m_8791_(uuid);
            if (e != null && clss.isAssignableFrom(e.getClass()) && pred.test(e)) {
                return (T)e;
            }
        } else {
            for (Entity e : ((ClientLevel)world).m_104735_()) {
                if (!e.m_20148_().equals(uuid) || !clss.isAssignableFrom(e.getClass()) || !pred.test(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public static ItemStack findItem(Player player, Predicate<ItemStack> pred, boolean searchArmor, boolean offHand) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!pred.test(stack)) continue;
            return stack;
        }
        if (searchArmor) {
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        if (offHand) {
            for (ItemStack stack : player.m_150109_().f_35976_) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }
}

