/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.platform.registry;

import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import io.github.flemmli97.tenshilib.platform.registry.VanillaEntrySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class VanillaRegistryHandler<T>
implements PlatformRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final String modid;
    private final Map<VanillaEntrySupplier<T>, Supplier<? extends T>> entries = new LinkedHashMap<VanillaEntrySupplier<T>, Supplier<? extends T>>();
    private final Set<VanillaEntrySupplier<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());

    public VanillaRegistryHandler(ResourceKey<? extends Registry<T>> key, String modid) {
        this.key = key;
        this.modid = modid;
    }

    @Override
    public <I extends T> RegistryEntrySupplier<I> register(String name, Supplier<? extends I> sup) {
        ResourceLocation id = new ResourceLocation(this.modid, name);
        VanillaEntrySupplier v = new VanillaEntrySupplier(id);
        this.entries.putIfAbsent(v, sup);
        return v;
    }

    @Override
    public void registerContent() {
        Registry registry = this.registryFrom();
        this.entries.forEach((v, s) -> {
            Object val = s.get();
            if (val instanceof CustomRegistryEntry) {
                CustomRegistryEntry entry = (CustomRegistryEntry)val;
                entry.setRegistryName(v.getID());
            }
            Registry.m_122965_((Registry)registry, (ResourceLocation)v.getID(), val);
            v.updateValue(registry);
        });
    }

    protected Registry<T> registryFrom() {
        Registry reg = (Registry)Registry.f_122897_.m_7745_(this.key.m_135782_());
        if (reg == null) {
            throw new NullPointerException("Failed to get a corresponding registry for " + this.key);
        }
        return reg;
    }

    @Override
    public Collection<? extends RegistryEntrySupplier<T>> getEntries() {
        return this.entriesView;
    }
}

