/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PancakeBlock
extends WaterBlock
implements ISoftFluidConsumer {
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[8];
    public static final IntegerProperty PANCAKES;
    public static final EnumProperty<ModBlockProperties.Topping> TOPPING;

    public PancakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PANCAKES, (Comparable)Integer.valueOf(1))).m_61124_(TOPPING, (Comparable)((Object)ModBlockProperties.Topping.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        Item item = stack.m_41720_();
        ModBlockProperties.Topping t = ModBlockProperties.Topping.fromItem(stack);
        if (t != ModBlockProperties.Topping.NONE) {
            if (state.m_61143_(TOPPING) == ModBlockProperties.Topping.NONE) {
                ItemStack returnItem;
                if (!worldIn.f_46443_) {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_(TOPPING, (Comparable)((Object)t)), 3);
                    worldIn.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.2f);
                }
                ItemStack itemStack = returnItem = t == ModBlockProperties.Topping.CHOCOLATE ? ItemStack.f_41583_ : new ItemStack((ItemLike)Items.f_42590_);
                if (!player.m_7500_()) {
                    Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)returnItem);
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
        } else {
            if (item == ModRegistry.PANCAKE_ITEM.get()) {
                return InteractionResult.PASS;
            }
            if (player.m_36391_(false)) {
                player.m_36324_().m_38707_(1, 0.1f);
                player.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (!worldIn.f_46443_) {
                    this.removeLayer(state, pos, worldIn, player);
                    return InteractionResult.CONSUME;
                }
                Minecraft.m_91087_().f_91061_.m_107355_(player.m_20183_().m_6630_(1), state);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void removeLayer(BlockState state, BlockPos pos, Level world, Player player) {
        BlockPos up;
        BlockState upState;
        int i = (Integer)state.m_61143_((Property)PANCAKES);
        if (i == 8 && (upState = world.m_8055_(up = pos.m_7494_())).m_60734_() == state.m_60734_()) {
            this.removeLayer(upState, up, world, player);
            return;
        }
        if (i > 1) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PANCAKES, (Comparable)Integer.valueOf(i - 1)), 3);
        } else {
            world.m_7471_(pos, false);
        }
        if (state.m_61143_(TOPPING) != ModBlockProperties.Topping.NONE) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 160));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)PANCAKES, (Comparable)Integer.valueOf(Math.min(8, (Integer)blockstate.m_61143_((Property)PANCAKES) + 1)));
        }
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.UP).m_83281_() || state.m_60783_(worldIn, pos, Direction.UP);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)PANCAKES) < 8 || super.m_6864_(state, useContext);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)PANCAKES) - 1];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PANCAKES, TOPPING, WATERLOGGED});
    }

    public boolean tryAcceptingFluid(Level world, BlockState state, BlockPos pos, SoftFluid f, CompoundTag nbt, int amount) {
        ModBlockProperties.Topping topping = ModBlockProperties.Topping.fromFluid(f);
        if (state.m_61143_(TOPPING) == ModBlockProperties.Topping.NONE && topping != ModBlockProperties.Topping.NONE) {
            world.m_7731_(pos, (BlockState)state.m_61124_(TOPPING, (Comparable)((Object)topping)), 2);
            world.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)(2.0 + (double)(l * 2)), (double)14.0));
        PANCAKES = ModBlockProperties.PANCAKES_1_8;
        TOPPING = ModBlockProperties.TOPPING;
    }
}

