/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.forge;

import com.mojang.blaze3d.platform.InputConstants;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.QuiverArrowSelectGui;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.QuiverLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.forge.QuiverArrowSelectGuiImpl;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventsForge {
    private static double wobble;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ClientEventsForge.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEventsForge::onAddLayers);
        bus.addListener(ClientEventsForge::onAddGuiLayers);
        bus.addListener(ClientEventsForge::onRegisterSkullModels);
        bus.addListener(ClientEventsForge::loadComplete);
        bus.addListener(ClientEventsForge::onPackReload);
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        ClientRegistry.checkIfFailed();
    }

    public static void onRegisterSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel(EndermanSkullBlock.TYPE, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(ModelLayers.f_171240_)));
        SkullBlockRenderer.f_112519_.put(EndermanSkullBlock.TYPE, Supplementaries.res("textures/entity/enderman_head.png"));
    }

    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer2;
        for (String skinType : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(skinType);
            if (renderer == null) continue;
            renderer.m_115326_(new QuiverLayer(renderer, false));
        }
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20524_);
        if (renderer != null) {
            renderer.m_115326_(new QuiverLayer(renderer, true));
        }
        if ((renderer2 = event.getRenderer(EntityType.f_20481_)) != null) {
            renderer2.m_115326_(new QuiverLayer(renderer2, true));
        }
    }

    public static void onAddGuiLayers(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "quiver_overlay", (IGuiOverlay)new QuiverArrowSelectGuiImpl());
    }

    @SubscribeEvent
    public static void itemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() != null) {
            ClientEvents.onItemTooltip(event.getItemStack(), event.getFlags(), event.getToolTip());
        }
    }

    @SubscribeEvent
    public static void screenInit(ScreenEvent.Init.Post event) {
        if (CompatHandler.CONFIGURED) {
            ClientEvents.addConfigButton(event.getScreen(), event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientEvents.onClientTick(Minecraft.m_91087_());
            if (QuiverArrowSelectGui.isUsingKey()) {
                QuiverArrowSelectGui.setUsingKeybind(InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)ClientRegistry.QUIVER_KEYBIND.getKey().m_84873_()));
            }
        }
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (QuiverArrowSelectGui.isActive() && QuiverArrowSelectGui.onMouseScrolled(event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        boolean isOnRope;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null && !Minecraft.m_91087_().m_91104_() && ((isOnRope = ClientEvents.isIsOnRope()) || wobble != 0.0)) {
            double period = ClientConfigs.Blocks.ROPE_WOBBLE_PERIOD.get();
            double newWobble = ((double)p.f_19797_ + event.getPartialTick()) / period % 1.0;
            wobble = !isOnRope && newWobble < wobble ? 0.0 : newWobble;
            event.setRoll((float)((double)event.getRoll() + (double)Mth.m_14031_((float)((float)(wobble * 2.0 * Math.PI))) * ClientConfigs.Blocks.ROPE_WOBBLE_AMPLITUDE.get()));
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        int a;
        if (Minecraft.m_91087_().f_91080_ == null && event.getKey() == ClientRegistry.QUIVER_KEYBIND.getKey().m_84873_() && !Minecraft.m_91087_().m_91104_() && (a = event.getAction()) < 2) {
            QuiverArrowSelectGui.setUsingKeybind(a == 1);
        }
    }

    public static void onPackReload(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            // empty if block
        }
    }
}

