/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleData;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class PicklePacket
implements Message {
    protected UUID playerID;
    protected final boolean on;

    private PicklePacket(UUID appliesTo, boolean on) {
        this.playerID = appliesTo;
        this.on = on;
    }

    private PicklePacket(FriendlyByteBuf buf) {
        this.on = buf.readBoolean();
        if (buf.isReadable()) {
            this.playerID = buf.m_130259_();
        }
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.on);
        if (this.playerID != null) {
            buf.m_130077_(this.playerID);
        }
    }

    public static class ClientBound
    extends PicklePacket {
        public ClientBound(UUID appliesTo, boolean on) {
            super(appliesTo, on);
        }

        public ClientBound(FriendlyByteBuf buf) {
            super(buf);
        }

        public void handle(ChannelHandler.Context context) {
            PickleData.set(this.playerID, this.on);
        }
    }

    public static class ServerBound
    extends PicklePacket {
        public ServerBound(UUID appliesTo, boolean on) {
            super(appliesTo, on);
        }

        public ServerBound(FriendlyByteBuf buf) {
            super(buf);
        }

        public void handle(ChannelHandler.Context context) {
            Player player = context.getSender();
            UUID id = player.m_36316_().getId();
            if (PickleData.isDev(id)) {
                PickleData.set(id, this.on);
                this.playerID = id;
                for (ServerPlayer p : player.m_20194_().m_6846_().m_11314_()) {
                    if (p == player) continue;
                    NetworkHandler.CHANNEL.sendToClientPlayer(p, (Message)new ClientBound(this.playerID, this.on));
                }
            }
        }
    }
}

