/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.blockentity;

import com.min01.archaeology.container.ContainerSingleItem;
import com.min01.archaeology.container.RandomizableContainer;
import com.min01.archaeology.init.ArchaeologyBlockEntityType;
import com.min01.archaeology.init.ArchaeologyItems;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DecoratedPotBlockEntity
extends BlockEntity
implements RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem {
    public static final String TAG_SHERDS = "sherds";
    public static final String TAG_ITEM = "item";
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    @Nullable
    public WobbleStyle lastWobbleStyle;
    private Decorations decorations;
    private ItemStack stack = ItemStack.f_41583_;
    @Nullable
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public DecoratedPotBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ArchaeologyBlockEntityType.DECORATED_POT.get(), position, state);
        this.decorations = Decorations.EMPTY;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.decorations.save(tag);
        if (!this.trySaveLootTable(tag) && !this.stack.m_41619_()) {
            tag.m_128365_(TAG_ITEM, (Tag)this.stack.m_41739_(new CompoundTag()));
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.decorations = Decorations.load(tag);
        if (!this.tryLoadLootTable(tag)) {
            this.stack = tag.m_128425_(TAG_ITEM, 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_ITEM)) : ItemStack.f_41583_;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public Decorations getDecorations() {
        return this.decorations;
    }

    public void setFromItem(ItemStack stack) {
        this.decorations = Decorations.load(BlockItem.m_186336_((ItemStack)stack));
    }

    public ItemStack getPotAsItem() {
        return DecoratedPotBlockEntity.createDecoratedPotItem(this.decorations);
    }

    public static ItemStack createDecoratedPotItem(Decorations decorations) {
        ItemStack stack = ((Item)ArchaeologyItems.DECORATED_POT.get()).m_7968_();
        CompoundTag tag = decorations.save(new CompoundTag());
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ArchaeologyBlockEntityType.DECORATED_POT.get()), (CompoundTag)tag);
        return stack;
    }

    @Override
    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    @Override
    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.stack;
    }

    @Override
    public ItemStack splitTheItem(int amount) {
        this.unpackLootTable(null);
        ItemStack stack = this.stack.m_41620_(amount);
        if (this.stack.m_41619_()) {
            this.stack = ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public void setTheItem(ItemStack stack) {
        this.unpackLootTable(null);
        this.stack = stack;
    }

    @Override
    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public void wobble(WobbleStyle wobbleStyle) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, wobbleStyle.ordinal());
        }
    }

    public boolean m_7531_(int event, int duration) {
        if (this.f_58857_ != null && event == 1 && duration >= 0 && duration < WobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.f_58857_.m_46467_();
            this.lastWobbleStyle = WobbleStyle.values()[duration];
            return true;
        }
        return super.m_7531_(event, duration);
    }

    public record Decorations(Item back, Item left, Item right, Item front) {
        public static final Decorations EMPTY = new Decorations(Items.f_42460_, Items.f_42460_, Items.f_42460_, Items.f_42460_);

        public CompoundTag save(CompoundTag tag) {
            ListTag listTag = new ListTag();
            this.sorted().forEach(item -> listTag.add((Object)StringTag.m_129297_((String)ForgeRegistries.ITEMS.getKey(item).toString())));
            tag.m_128365_(DecoratedPotBlockEntity.TAG_SHERDS, (Tag)listTag);
            return tag;
        }

        public Stream<Item> sorted() {
            return Stream.of(this.back, this.left, this.right, this.front);
        }

        public static Decorations load(@Nullable CompoundTag tag) {
            if (tag != null && tag.m_128425_(DecoratedPotBlockEntity.TAG_SHERDS, 9)) {
                ListTag listTag = tag.m_128437_(DecoratedPotBlockEntity.TAG_SHERDS, 8);
                return new Decorations(Decorations.itemFromTag(listTag, 0), Decorations.itemFromTag(listTag, 1), Decorations.itemFromTag(listTag, 2), Decorations.itemFromTag(listTag, 3));
            }
            return EMPTY;
        }

        private static Item itemFromTag(ListTag listTag, int index) {
            if (index >= listTag.size()) {
                return Items.f_42460_;
            }
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(listTag.get(index).m_7916_()));
        }
    }

    public static enum WobbleStyle {
        POSITIVE(7),
        NEGATIVE(10);

        public final int duration;

        private WobbleStyle(int duration) {
            this.duration = duration;
        }
    }
}

