/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.vanilla;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.liolib.core.animatable.GeoAnimatable;
import net.liopyu.liolib.core.animatable.instance.AnimatableInstanceCache;
import net.liopyu.liolib.util.GeckoLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BoatEntityJS
extends Boat
implements IAnimatableJSNL {
    protected final BoatJSBuilder builder;
    private final AnimatableInstanceCache getAnimatableInstanceCache;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private int deltaRotation;
    private float invFriction;
    private float outOfControlTicks;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private double waterLevel;
    private float landFriction;
    private Boat.Status status;
    private Boat.Status oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(BoatEntityJS.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BoatEntityJS(BoatJSBuilder builder, EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    @Override
    public BaseEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.getAnimatableInstanceCache;
    }

    public String entityName() {
        return this.m_6095_().toString();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
    }

    private boolean m_38393_() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!this.canBoatInFluid(fluidstate)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Boat.Status m_38394_() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!this.canBoatInFluid(fluidstate) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Boat.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Boat.Status.UNDER_WATER : null;
    }

    private Boat.Status m_38392_() {
        Boat.Status boat$status = this.m_38394_();
        if (boat$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return boat$status;
        }
        if (this.m_38393_()) {
            return Boat.Status.IN_WATER;
        }
        float f = this.m_38377_();
        if (f > 0.0f) {
            this.landFriction = f;
            return Boat.Status.ON_LAND;
        }
        return Boat.Status.IN_AIR;
    }

    private void m_38391_() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    private void m_38395_() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.m_38371_() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Boat.Status.IN_WATER;
        } else {
            if (this.status == Boat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Boat.Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.getControllingPassenger() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.invFriction, vec3.f_82480_ + d1, vec3.f_82481_ * (double)this.invFriction);
            this.deltaRotation *= (int)this.invFriction;
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, (vec31.f_82480_ + d2 * 0.06153846016296973) * 0.75, vec31.f_82481_);
            }
        }
    }

    private int m_38397_() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_BUBBLE_TIME);
    }

    public void m_38366_(int pBubbleTime) {
        this.f_19804_.m_135381_(DATA_ID_BUBBLE_TIME, (Object)pBubbleTime);
    }

    private void m_38388_() {
        if (this.f_19853_.f_46443_) {
            int k = this.m_38397_();
            this.bubbleMultiplier = k > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = Mth.m_14036_((float)this.bubbleMultiplier, (float)0.0f, (float)1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5f * (float)this.f_19853_.m_46467_()) * this.bubbleMultiplier;
        } else {
            int k;
            if (!this.isAboveBubbleColumn) {
                this.m_38366_(0);
            }
            if ((k = this.m_38397_()) > 0) {
                this.m_38366_(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.m_38366_(0);
                    Vec3 vec3 = this.m_20184_();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.m_20256_(vec3.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vec3.f_82479_, this.m_146862_(p_150274_ -> p_150274_ instanceof Player) ? 2.7 : 0.6, vec3.f_82481_);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    public void m_8119_() {
        this.oldStatus = this.status;
        this.status = this.m_38392_();
        this.outOfControlTicks = this.status != Boat.Status.UNDER_WATER && this.status != Boat.Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.f_19853_.f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.m_38385_() > 0) {
            this.m_38354_(this.m_38385_() - 1);
        }
        if (this.m_38384_() > 0.0f) {
            this.m_38311_(this.m_38384_() - 1.0f);
        }
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
        super.m_6075_();
        this.m_38391_();
        if (this.m_6109_()) {
            if (!(this.m_146895_() instanceof Player)) {
                this.m_38339_(false, false);
            }
            this.m_38395_();
            if (this.f_19853_.f_46443_) {
                this.m_38396_();
                this.f_19853_.m_5503_((Packet)new ServerboundPaddleBoatPacket(this.m_38313_(0), this.m_38313_(1)));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_38388_();
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.getControllingPassenger() instanceof Player);
            for (Entity value : list) {
                if (value.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < this.m_213801_() && !value.m_20159_() && value.m_20205_() < this.m_20205_() && value instanceof LivingEntity && !(value instanceof WaterAnimal) && !(value instanceof Player)) {
                    value.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(value);
            }
        }
    }

    public void m_38342_(boolean pInputLeft, boolean pInputRight, boolean pInputUp, boolean pInputDown) {
        this.inputLeft = pInputLeft;
        this.inputRight = pInputRight;
        this.inputUp = pInputUp;
        this.inputDown = pInputDown;
    }

    public void m_38396_() {
        if (this.m_20160_()) {
            Object obj;
            float f = 0.0f;
            if (this.inputLeft) {
                --this.deltaRotation;
            }
            if (this.inputRight) {
                ++this.deltaRotation;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                if (this.builder.turningBoatSpeed != null) {
                    obj = EntityJSHelperClass.convertObjectToDesired(this.builder.turningBoatSpeed.apply(this), "float");
                    if (obj != null) {
                        f += ((Float)obj).floatValue();
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for turningBoatSpeed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a float. Defaulting to 0.005");
                        f += 0.005f;
                    }
                } else {
                    f += 0.005f;
                }
            }
            this.m_146922_(this.m_146908_() + (float)this.deltaRotation);
            if (this.inputUp) {
                if (this.builder.forwardBoatSpeed != null) {
                    obj = EntityJSHelperClass.convertObjectToDesired(this.builder.forwardBoatSpeed.apply(this), "float");
                    if (obj != null) {
                        f += ((Float)obj).floatValue();
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for forwardBoatSpeed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a float. Defaulting to 0.04");
                        f += 0.04f;
                    }
                } else {
                    f += 0.04f;
                }
            }
            if (this.inputDown) {
                if (this.builder.backwardsBoatSpeed != null) {
                    obj = EntityJSHelperClass.convertObjectToDesired(this.builder.backwardsBoatSpeed.apply(this), "float");
                    if (obj != null) {
                        f -= ((Float)obj).floatValue();
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for backwardsBoatSpeed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a float. Defaulting to 0.005");
                        f -= 0.005f;
                    }
                } else {
                    f -= 0.005f;
                }
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.m_38339_(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    public Item m_38369_() {
        if (this.builder.getDropItem != null) {
            Object obj = this.builder.getDropItem.apply(this);
            if (obj instanceof Item) {
                Item i = (Item)obj;
                return i;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getDropItem in builder: " + obj + ". Must be an Item. Defaulting to super method: " + super.m_38369_());
        }
        return super.m_38369_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((Entity)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        super.m_6478_(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.move, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: move.");
        }
    }

    public void m_6123_(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.m_6123_(player);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.m_8038_(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.m_142535_(distance, damageMultiplier, damageSource);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.builder.onAddedToWorld != null && !this.f_19853_.m_5776_()) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    public void m_6858_(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.m_6858_(sprinting);
    }

    public void m_8127_() {
        super.m_8127_();
        if (this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void m_142036_() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.m_142036_();
    }

    public void m_20093_() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.m_20093_();
    }

    protected void m_142043_() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.m_142043_();
    }

    public boolean m_6783_(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_6783_(distance));
        }
        return super.m_6783_(distance);
    }

    public boolean m_6097_() {
        return this.builder.isAttackable;
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.m_146895_();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7337_(pEntity));
        }
        return super.m_7337_(pEntity);
    }

    protected float m_20098_() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.m_20098_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.m_20098_());
        return super.m_20098_();
    }

    public boolean m_6094_() {
        return this.builder.isPushable;
    }

    protected float m_6041_() {
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.m_6041_());
        return super.m_6041_();
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.m_7310_(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_7310_(entity));
        return super.m_7310_(entity);
    }

    protected boolean m_142039_() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142039_());
        }
        return super.m_142039_();
    }

    protected boolean m_6093_() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.m_6093_());
    }

    protected float m_6059_() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.m_6059_());
        }
        return super.m_6059_();
    }

    protected SoundEvent m_5509_() {
        if (this.builder.setSwimSplashSound == null) {
            return super.m_5509_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent m_5501_() {
        if (this.builder.setSwimSound == null) {
            return super.m_5501_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean m_142079_() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142079_());
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203117_());
        }
        return super.m_203117_();
    }

    public boolean m_142038_() {
        if (this.builder.isCurrentlyGlowing != null && !this.f_19853_.m_5776_()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142038_());
        }
        return super.m_142038_();
    }

    public boolean m_213854_() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213854_());
        }
        return super.m_213854_();
    }

    public boolean m_20152_() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_20152_());
        }
        return super.m_20152_();
    }

    public boolean m_6673_(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6673_(p_20122_));
        }
        return super.m_6673_(p_20122_);
    }

    public boolean m_6072_() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6072_());
        }
        return super.m_6072_();
    }

    public boolean m_142265_(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142265_(p_146843_, p_146844_));
        }
        return super.m_142265_(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int m_6056_() {
        if (this.builder.setMaxFallDistance == null) {
            return super.m_6056_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.m_6056_());
        return super.m_6056_();
    }
}

