/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.implementation;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.events.BiomeSpawnsEventJS;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class EventBasedSpawnModifier
implements BiomeModifier {
    private final BiomeSpawnsEventJS event;

    public EventBasedSpawnModifier() {
        if (EventHandlers.biomeSpawns.hasListeners()) {
            this.event = new BiomeSpawnsEventJS();
            EventHandlers.biomeSpawns.post((EventJS)this.event);
        } else {
            this.event = null;
        }
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        MobSpawnSettingsBuilder spawnsBuilder = builder.getMobSpawnSettings();
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeSpawn biomeSpawn : BaseLivingEntityBuilder.biomeSpawnList) {
                MobSpawnSettings.SpawnerData spawnerData2 = biomeSpawn.spawnerData().get();
                for (Either<ResourceLocation, TagKey<Biome>> either : biomeSpawn.biomes()) {
                    either.map(rl -> {
                        if (biome.m_203373_(rl)) {
                            spawnsBuilder.m_48376_(spawnerData.f_48404_.m_20674_(), spawnerData2);
                        }
                        return rl;
                    }, tag -> {
                        if (biome.m_203656_(tag)) {
                            spawnsBuilder.m_48376_(spawnerData.f_48404_.m_20674_(), spawnerData2);
                        }
                        return tag;
                    });
                }
            }
            if (this.event != null) {
                for (BiomeSpawnsEventJS.Addition addition : this.event.additions) {
                    for (Either either : addition.biomes()) {
                        either.map(rl -> {
                            if (biome.m_203373_(rl)) {
                                spawnsBuilder.m_48376_(addition.entityType().m_20674_(), addition.spawnData());
                            }
                            return rl;
                        }, tag -> {
                            if (biome.m_203656_(tag)) {
                                spawnsBuilder.m_48376_(addition.entityType().m_20674_(), addition.spawnData());
                            }
                            return tag;
                        });
                    }
                }
            }
        }
        if (this.event != null && phase == BiomeModifier.Phase.REMOVE) {
            for (BiomeSpawnsEventJS.Removal removal : this.event.removals) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                for (Either<ResourceLocation, TagKey<Biome>> either : removal.biomes()) {
                    either.map(rl -> {
                        if (biome.m_203373_(rl)) {
                            atomicBoolean.set(true);
                        }
                        return rl;
                    }, tag -> {
                        if (biome.m_203656_(tag)) {
                            atomicBoolean.set(true);
                        }
                        return tag;
                    });
                    if (!atomicBoolean.get()) continue;
                    break;
                }
                if (!atomicBoolean.get()) continue;
                EntityType<?> entityType = removal.entityType();
                spawnsBuilder.getSpawner(entityType.m_20674_()).removeIf(spawnerData -> spawnerData.f_48404_ == type);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)RegistryUtil.EVENT_SPAWN_MODIFIER.get();
    }

    public record BiomeSpawn(List<Either<ResourceLocation, TagKey<Biome>>> biomes, Supplier<MobSpawnSettings.SpawnerData> spawnerData) {
    }
}

