/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedFluids;
        public final ForgeConfigSpec.ConfigValue<Integer> capacity;
        public final ForgeConfigSpec.ConfigValue<Double> range;
        public final ForgeConfigSpec.ConfigValue<Boolean> formatting;
        public final ForgeConfigSpec.ConfigValue<Boolean> anvilRepair;
        public List<String> defaultValues = new ArrayList<String>();
        public int defaultCapacity = 100000000;
        public double defaultRange = 8.0;
        public boolean defaultFormatting = true;
        public boolean defaultAnvilRepair = true;

        public Common(ForgeConfigSpec.Builder builder) {
            this.defaultValues.add("mob_grinding_utils:fluid_xp");
            this.defaultValues.add("cofh_core:experience");
            this.defaultValues.add("industrialforegoing:essence");
            this.defaultValues.add("sophisticatedcore:xp_still");
            this.defaultValues.add("enderio:xp_juice");
            builder.push("Allowed Experience Fluids");
            this.allowedFluids = builder.comment("Add IDs of fluids you want the obelisk to support here in the form mod_id:fluid_name. Fluids have to be tagged forge:experience.").define("AllowedFluids", this.defaultValues);
            builder.pop();
            builder.push("Experience Obelisk Capacity");
            this.capacity = builder.comment("The fluid capacity of the obelisk in mB. Default = 100000000. This is ~1072 levels' worth.").defineInRange("Capacity", this.defaultCapacity, 20, 0x7FFFFFF8);
            builder.pop();
            builder.push("Enlightened Amulet Range");
            this.range = builder.comment("The range of the enlightened amulet. Accepts decimals. Default = 8.0.").defineInRange("Range", this.defaultRange, 1.0, 32.0);
            builder.pop();
            builder.push("Enable Name Formatting Anvil Recipes");
            this.formatting = builder.comment("Whether custom recipes that allow for the changing of item name color & formatting are enabled").define("Formatting", this.defaultFormatting);
            builder.pop();
            builder.push("Enable Anvil Repair Recipes");
            this.anvilRepair = builder.comment("Whether custom recipes that allow for the repairing of anvils with iron ingots are allowed").define("AnvilRepair", this.defaultAnvilRepair);
            builder.pop();
        }
    }
}

