/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.Locatables;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.menu.ISubMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost
implements InternalInventoryHost,
ISegmentedInventory {
    private final AppEngInternalInventory singularityInventory = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final AppEngInternalInventory viewCellInventory = new AppEngInternalInventory((InternalInventoryHost)this, 5);
    private final Player myPlayer;
    private boolean rangeCheck;
    private IActionHost securityTerminal;
    private IGridNode securityTerminalNode;
    private IActionHost quantumBridge;
    private IUpgradeInventory upgradeInventory;
    public static final ResourceLocation INV_SINGULARITY = new ResourceLocation("ae2wtlib", "singularity");

    public WTMenuHost(Player player, @Nullable Integer inventorySlot, ItemStack is, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, inventorySlot, is, returnToMainMenu);
        this.myPlayer = player;
        this.upgradeInventory = UpgradeInventories.forItem((ItemStack)is, (int)WUTHandler.getUpgradeCardCount(), this::updateUpgrades);
        if (((WirelessTerminalItem)is.m_41720_()).getGridKey(is).isEmpty()) {
            return;
        }
        this.securityTerminal = (IActionHost)Locatables.securityStations().get(player.f_19853_, ((WirelessTerminalItem)is.m_41720_()).getGridKey(is).getAsLong());
        if (this.securityTerminal != null) {
            this.securityTerminalNode = this.securityTerminal.getActionableNode();
        }
    }

    public void updateUpgrades(ItemStack stack, IUpgradeInventory upgrades) {
        this.upgradeInventory = upgrades;
    }

    protected void readFromNbt() {
        CompoundTag tag = this.getItemStack().m_41784_();
        this.viewCellInventory.readFromNBT(tag, "viewcells");
        this.singularityInventory.readFromNBT(tag, "singularity");
    }

    public void saveChanges() {
        CompoundTag tag = this.getItemStack().m_41784_();
        this.viewCellInventory.writeToNBT(tag, "viewcells");
        this.singularityInventory.writeToNBT(tag, "singularity");
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
    }

    public IGridNode getActionableNode() {
        IGridNode node = super.getActionableNode();
        if (node != null) {
            return node;
        }
        return this.securityTerminalNode;
    }

    public boolean rangeCheck() {
        this.rangeCheck = super.rangeCheck();
        return this.isQuantumLinked() || this.rangeCheck;
    }

    public boolean hasQuantumUpgrade() {
        return this.upgradeInventory.isInstalled((ItemLike)AE2wtlib.QUANTUM_BRIDGE_CARD);
    }

    public boolean isQuantumLinked() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            return true;
        }
        if (!this.hasQuantumUpgrade()) {
            return false;
        }
        long frequency = this.getQEFrequency();
        if (frequency == 0L) {
            return false;
        }
        if (this.quantumBridge == null) {
            if (!this.findQuantumBridge(frequency)) {
                return false;
            }
        } else {
            IActionHost iActionHost = this.quantumBridge;
            if (iActionHost instanceof QuantumCluster) {
                QuantumCluster quantumCluster = (QuantumCluster)iActionHost;
                if (quantumCluster.getCenter() == null) {
                    return false;
                }
                long frequencyOther = quantumCluster.getCenter().getQEFrequency();
                if (frequencyOther != frequency && frequencyOther != -frequency && !this.findQuantumBridge(frequency)) {
                    return false;
                }
            } else if (!this.findQuantumBridge(frequency)) {
                return false;
            }
        }
        if (this.quantumBridge.getActionableNode() == null || this.securityTerminalNode == null) {
            return false;
        }
        return this.quantumBridge.getActionableNode().getGrid() == this.securityTerminalNode.getGrid();
    }

    private long getQEFrequency() {
        CompoundTag c;
        ItemStack is = this.singularityInventory.getStackInSlot(0);
        if (!is.m_41619_() && (c = is.m_41783_()) != null) {
            return c.m_128454_("freq");
        }
        return 0L;
    }

    private boolean findQuantumBridge(long frequency) {
        this.quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(this.getPlayer().m_9236_(), frequency);
        if (this.quantumBridge == null) {
            this.quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(this.getPlayer().m_9236_(), -frequency);
        }
        return this.quantumBridge != null;
    }

    public Player getPlayer() {
        return this.myPlayer;
    }

    public AppEngInternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        if (this.rangeCheck) {
            super.setPowerDrainPerTick(powerDrainPerTick);
        } else {
            super.setPowerDrainPerTick(AE2wtlibConfig.INSTANCE.getOutOfRangePower());
        }
    }

    public boolean drainPower() {
        if (!super.drainPower()) {
            return false;
        }
        this.recharge();
        return true;
    }

    private void recharge() {
        if (this.quantumBridge == null) {
            return;
        }
        Item item = this.getItemStack().m_41720_();
        if (item instanceof AEBasePoweredItem) {
            AEBasePoweredItem item2 = (AEBasePoweredItem)item;
            double currentPower = item2.getAECurrentPower(this.getItemStack());
            double maxPower = item2.getAEMaxPower(this.getItemStack());
            double missing = maxPower - currentPower;
            if (this.getActionableNode() == null) {
                return;
            }
            double extracted = this.getActionableNode().getGrid().getEnergyService().extractAEPower(missing, Actionable.MODULATE, PowerMultiplier.ONE);
            item2.injectAEPower(this.getItemStack(), extracted, Actionable.MODULATE);
        }
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)INV_SINGULARITY)) {
            return this.singularityInventory;
        }
        return null;
    }

    public boolean stillValid() {
        return this.ensureItemStillInSlot();
    }

    public IActionHost getActionHost() {
        return this.securityTerminal;
    }

    protected boolean ensureItemStillInSlot() {
        if (this.getSlot() != null) {
            return super.ensureItemStillInSlot();
        }
        return Platform.isStillPresentTrinkets(this.getPlayer(), this.getItemStack());
    }
}

