/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.util;

import cech12.bucketlib.api.BucketLibTags;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.config.ServerConfig;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketLibUtil {
    public static final ResourceLocation MILK_LOCATION = new ResourceLocation("milk");
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    private BucketLibUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean notCreative(Entity entity) {
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.m_150110_().f_35937_) return false;
        return true;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return !BucketLibUtil.containsFluid(itemStack) && !BucketLibUtil.containsMilk(itemStack) && !BucketLibUtil.containsEntityType(itemStack) && !BucketLibUtil.containsBlock(itemStack);
    }

    public static ItemStack createEmptyResult(ItemStack initialStack, Player player, ItemStack resultStack, InteractionHand hand) {
        if (!BucketLibUtil.notCreative((Entity)player)) {
            return initialStack;
        }
        if (resultStack.m_41619_()) {
            if (!initialStack.m_41619_()) {
                if (!player.m_20067_()) {
                    player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, player.m_5720_(), 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f, false);
                }
                player.m_21060_(initialStack, 5);
            }
            player.m_36246_(Stats.f_12983_.m_12902_((Object)initialStack.m_41720_()));
        }
        return resultStack;
    }

    public static void damageByOne(ItemStack stack, RandomSource random, ServerPlayer player) {
        if (!stack.m_41619_() && stack.m_41763_() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack) && stack.m_220157_(1, random, player)) {
            stack.m_41774_(1);
            stack.m_41721_(0);
        }
    }

    public static void damageByOne(ItemStack stack) {
        BucketLibUtil.damageByOne(stack, RANDOM, null);
    }

    public static boolean isAffectedByInfinityEnchantment(@Nonnull ItemStack itemStack) {
        if (!((Boolean)ServerConfig.INFINITY_ENCHANTMENT_ENABLED.get()).booleanValue()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucket = (UniversalBucketItem)item;
            Fluid fluid = BucketLibUtil.getFluid(itemStack);
            return fluid != Fluids.f_76191_ && Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).getTag(BucketLibTags.Fluids.INFINITY_ENCHANTABLE).contains((Object)fluid) && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0 && bucket.canHoldFluid(fluid);
        }
        return false;
    }

    private static boolean containsTagContent(ItemStack itemStack, String tagName) {
        CompoundTag nbt = itemStack.m_41783_();
        return nbt != null && nbt.m_128441_(tagName);
    }

    private static String getTagContent(ItemStack itemStack, String tagName) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && nbt.m_128441_(tagName)) {
            return nbt.m_128461_(tagName);
        }
        return null;
    }

    private static ItemStack setTagContent(ItemStack itemStack, String tagName, String tagContent) {
        ItemStack result = itemStack.m_41777_();
        CompoundTag nbt = result.m_41784_();
        nbt.m_128359_(tagName, tagContent);
        result.m_41751_(nbt);
        return result;
    }

    private static ItemStack removeTagContentNoCopy(ItemStack itemStack, String tagName) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && nbt.m_128441_(tagName)) {
            nbt.m_128473_(tagName);
            if (nbt.m_128456_()) {
                itemStack.m_41751_(null);
            } else {
                itemStack.m_41751_(nbt);
            }
        }
        return itemStack;
    }

    private static ItemStack removeTagContent(ItemStack itemStack, String tagName) {
        return BucketLibUtil.removeTagContentNoCopy(itemStack.m_41777_(), tagName);
    }

    public static boolean containsContent(ItemStack itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "BucketContent");
    }

    public static ResourceLocation getContent(ItemStack itemStack) {
        String content = BucketLibUtil.getTagContent(itemStack, "BucketContent");
        if (content != null) {
            return new ResourceLocation(content);
        }
        return null;
    }

    public static ItemStack addContent(ItemStack itemStack, ResourceLocation content) {
        return BucketLibUtil.setTagContent(itemStack, "BucketContent", content.toString());
    }

    public static ItemStack removeContent(ItemStack itemStack) {
        return BucketLibUtil.removeContent(itemStack, true);
    }

    public static ItemStack removeContentNoCopy(ItemStack itemStack, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContentNoCopy(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack);
        }
        return emptyStack;
    }

    private static ItemStack removeContent(ItemStack itemStack, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContent(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack);
        }
        return emptyStack;
    }

    public static boolean containsMilk(ItemStack itemStack) {
        ResourceLocation bucketContent = BucketLibUtil.getContent(itemStack);
        if (bucketContent != null && bucketContent.equals((Object)MILK_LOCATION)) {
            return true;
        }
        if (ForgeMod.MILK.isPresent()) {
            return BucketLibUtil.getFluid(itemStack) == ForgeMod.MILK.get();
        }
        return false;
    }

    public static ItemStack addMilk(ItemStack itemStack) {
        ItemStack filledStack = itemStack;
        if (ForgeMod.MILK.isPresent()) {
            filledStack = BucketLibUtil.addFluid(filledStack, (Fluid)ForgeMod.MILK.get());
        }
        return BucketLibUtil.addContent(filledStack, MILK_LOCATION);
    }

    public static ItemStack removeMilk(ItemStack itemStack) {
        return BucketLibUtil.removeFluid(itemStack);
    }

    public static boolean containsFluid(ItemStack itemStack) {
        return BucketLibUtil.getFluid(itemStack) != Fluids.f_76191_;
    }

    public static Fluid getFluid(ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(fluidHandler -> fluidHandler.getFluidInTank(0)).orElse(FluidStack.EMPTY).getFluid();
    }

    public static ItemStack addFluid(ItemStack itemStack, Fluid fluid) {
        AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(itemStack.m_41777_());
        FluidUtil.getFluidHandler((ItemStack)resultItemStack.get()).ifPresent(fluidHandler -> {
            fluidHandler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            resultItemStack.set(fluidHandler.getContainer());
        });
        return resultItemStack.get();
    }

    public static ItemStack removeFluid(ItemStack itemStack) {
        AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(itemStack.m_41777_());
        if (BucketLibUtil.containsMilk(itemStack)) {
            resultItemStack.set(BucketLibUtil.removeContent(resultItemStack.get(), !BucketLibUtil.containsFluid(resultItemStack.get())));
        }
        FluidUtil.getFluidHandler((ItemStack)resultItemStack.get()).ifPresent(fluidHandler -> {
            fluidHandler.drain(new FluidStack(fluidHandler.getFluidInTank(0).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
            resultItemStack.set(fluidHandler.getContainer());
        });
        return resultItemStack.get();
    }

    public static boolean containsEntityType(ItemStack itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "EntityType");
    }

    public static EntityType<?> getEntityType(ItemStack itemStack) {
        String content = BucketLibUtil.getTagContent(itemStack, "EntityType");
        if (content != null) {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(content));
        }
        return null;
    }

    public static ItemStack addEntityType(ItemStack itemStack, EntityType<?> entityType) {
        return BucketLibUtil.setTagContent(itemStack, "EntityType", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).toString());
    }

    public static ItemStack removeEntityType(ItemStack itemStack, boolean damage) {
        ItemStack emptyStack = BucketLibUtil.removeTagContent(itemStack, "EntityType");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack);
        }
        return emptyStack;
    }

    public static boolean containsBlock(ItemStack itemStack) {
        return BucketLibUtil.containsContent(itemStack) && !BucketLibUtil.containsMilk(itemStack);
    }

    public static Block getBlock(ItemStack itemStack) {
        ResourceLocation content;
        if (!BucketLibUtil.containsMilk(itemStack) && (content = BucketLibUtil.getContent(itemStack)) != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(content);
        }
        return null;
    }

    public static ItemStack addBlock(ItemStack itemStack, Block block) {
        ResourceLocation blockLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockLocation != null) {
            return BucketLibUtil.addContent(itemStack, blockLocation);
        }
        return itemStack.m_41777_();
    }

    public static ItemStack removeBlock(ItemStack itemStack) {
        if (!BucketLibUtil.containsMilk(itemStack)) {
            return BucketLibUtil.removeContent(itemStack);
        }
        return itemStack.m_41777_();
    }
}

