/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;
import owmii.powah.lib.client.util.RenderTypes;
import owmii.powah.lib.util.math.V3d;

public class EnergizingRodRenderer
extends AbstractTileRenderer<EnergizingRodTile> {
    public static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("powah", "textures/model/tile/beam.png");
    private static final RenderType RENDER_TYPE = RenderTypes.entityBlendedNoDept(BEAM_TEXTURE);

    protected EnergizingRodRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(EnergizingRodTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        EnergizingOrbTile orb;
        boolean flag = false;
        for (InteractionHand hand : InteractionHand.values()) {
            IWrench wrench;
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (!(item instanceof IWrench) || !(wrench = (IWrench)item).getWrenchMode(stack).link()) continue;
            flag = true;
            break;
        }
        if ((orb = te.getOrbTile()) != null && (te.coolDown.ended() || flag)) {
            matrix.m_85836_();
            matrix.m_85837_(0.5, 0.5, 0.5);
            V3d pos = V3d.from(te.m_58899_()).center();
            V3d orbPos = V3d.from(orb.getOrbCenter());
            float f2 = 1.0f;
            float f3 = f2 * 0.5f % 1.0f;
            Vec3 vec3d2 = pos.m_82546_(orbPos);
            double d0 = vec3d2.m_82553_();
            vec3d2 = vec3d2.m_82541_();
            float f5 = (float)Math.acos(Mth.m_14008_((double)vec3d2.f_82480_, (double)-1.0, (double)1.0));
            float f6 = (float)Mth.m_14136_((double)vec3d2.f_82481_, (double)vec3d2.f_82479_);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_((1.5707964f - f6) * 57.295776f));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(f5 * 57.295776f));
            float d1 = f2 * 0.0f;
            float d12 = Mth.m_14089_((float)((float)((double)d1 + Math.PI))) * 0.12f;
            float d13 = Mth.m_14031_((float)((float)((double)d1 + Math.PI))) * 0.12f;
            float d14 = Mth.m_14089_((float)d1) * 0.12f;
            float d15 = Mth.m_14031_((float)d1) * 0.12f;
            float d16 = Mth.m_14089_((float)((float)((double)d1 + 1.5707963267948966))) * 0.12f;
            float d17 = Mth.m_14031_((float)((float)((double)d1 + 1.5707963267948966))) * 0.12f;
            float d18 = Mth.m_14089_((float)((float)((double)d1 + 4.71238898038469))) * 0.12f;
            float d19 = Mth.m_14031_((float)((float)((double)d1 + 4.71238898038469))) * 0.12f;
            float d22 = f3 - 1.0f;
            float d23 = (float)(d0 * 5.05 + (double)d22);
            VertexConsumer builder = rtb.m_6299_(RENDER_TYPE);
            PoseStack.Pose last = matrix.m_85850_();
            Matrix4f matrix4f = last.m_85861_();
            Matrix3f matrix3f = last.m_85864_();
            int color = ((Tier)te.getVariant()).getColor();
            int r = 0xFF & color >> 16;
            int g = 0xFF & color >> 8;
            int b = 0xFF & color;
            this.pos(builder, matrix4f, matrix3f, d12, 0.0f, d13, r, g, b, 1.0f, d23);
            this.pos(builder, matrix4f, matrix3f, d12, (float)(-d0), d13, r, g, b, 1.0f, d22);
            this.pos(builder, matrix4f, matrix3f, d14, (float)(-d0), d15, r, g, b, 0.0f, d22);
            this.pos(builder, matrix4f, matrix3f, d14, 0.0f, d15, r, g, b, 0.0f, d23);
            this.pos(builder, matrix4f, matrix3f, d16, 0.0f, d17, r, g, b, 1.0f, d23);
            this.pos(builder, matrix4f, matrix3f, d16, (float)(-d0), d17, r, g, b, 1.0f, d22);
            this.pos(builder, matrix4f, matrix3f, d18, (float)(-d0), d19, r, g, b, 0.0f, d22);
            this.pos(builder, matrix4f, matrix3f, d18, 0.0f, d19, r, g, b, 0.0f, d23);
            matrix.m_85849_();
        }
    }

    private void pos(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int r, int g, int b, float u, float v) {
        builder.m_85982_(matrix4f, x, y, z).m_6122_(r, g, b, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0x780078).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

