/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.client.handler.IHudItem;
import owmii.powah.lib.item.ItemBase;
import owmii.powah.lib.logistics.energy.SideConfig;

public class WrenchItem
extends ItemBase
implements IHudItem,
IWrench {
    private static final Direction[] DIRECTIONS = Direction.values();

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        BlockState rotatedState;
        IWrenchable iWrenchable;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IWrenchable && (iWrenchable = (IWrenchable)block).onWrench(state, world, pos, player, hand, side, this.getWrenchMode(stack), hit)) {
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_ && this.getWrenchMode(stack).config() && te instanceof CableTile) {
            CableTile cable = (CableTile)te;
            if (stack.m_41720_() instanceof WrenchItem) {
                Optional<Direction> sides = CableBlock.getHitSide(hit, pos);
                boolean[] flag = new boolean[]{false};
                sides.ifPresent(direction -> {
                    SideConfig config = cable.getSideConfig();
                    config.nextType((Direction)direction);
                    cable.sync();
                });
                return InteractionResult.SUCCESS;
            }
        }
        if (this.getWrenchMode(stack).rotate() && (state.m_60734_() instanceof AbstractEnergyBlock || state.m_60734_() instanceof EnergizingOrbBlock) && !state.equals(rotatedState = this.rotateState(world, state, pos))) {
            world.m_46597_(pos, rotatedState);
            world.m_5594_(player, pos, rotatedState.m_60734_().m_49962_(rotatedState).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.onItemUseFirst(stack, world, pos, player, hand, side, hit);
    }

    private BlockState rotateState(Level world, BlockState state, BlockPos pos) {
        for (Property property : state.m_61147_()) {
            if (!property.m_61708_().equals("facing") || !(property instanceof DirectionProperty)) continue;
            DirectionProperty dirProp = (DirectionProperty)property;
            Direction current = (Direction)state.m_61143_((Property)dirProp);
            Direction rotated = WrenchItem.nextDirection(current);
            while (!property.m_6908_().contains(rotated) || !((BlockState)state.m_61124_((Property)dirProp, (Comparable)rotated)).m_60710_((LevelReader)world, pos)) {
                if ((rotated = WrenchItem.nextDirection(rotated)) != current) continue;
                return state;
            }
            return (BlockState)state.m_61124_((Property)dirProp, (Comparable)rotated);
        }
        return state;
    }

    private static Direction nextDirection(Direction dir) {
        return DIRECTIONS[(dir.ordinal() + 1) % DIRECTIONS.length];
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            this.nextWrenchMode(stack);
            playerIn.m_5661_((Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            this.oneTimeInfo(player, stack, (Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean renderHud(Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        return false;
    }

    private boolean changeWrenchMode(ItemStack stack, boolean next) {
        if (stack.m_41720_() instanceof IWrench) {
            if (next) {
                this.nextWrenchMode(stack);
                return true;
            }
            this.prevWrenchMode(stack);
            return true;
        }
        return false;
    }

    private void nextWrenchMode(ItemStack stack) {
        int j;
        CompoundTag nbt;
        int i = (nbt = this.getWrenchNBT(stack)).m_128451_("WrenchMode") + 1;
        nbt.m_128405_("WrenchMode", i > (j = WrenchMode.values().length - 1) ? 0 : i);
    }

    private void prevWrenchMode(ItemStack stack) {
        int j;
        CompoundTag nbt;
        int i = (nbt = this.getWrenchNBT(stack)).m_128451_("WrenchMode") - 1;
        nbt.m_128405_("WrenchMode", i < (j = WrenchMode.values().length - 1) ? j : i);
    }

    @Override
    public WrenchMode getWrenchMode(ItemStack stack) {
        return WrenchMode.values()[this.getWrenchNBT(stack).m_128451_("WrenchMode")];
    }

    public CompoundTag getWrenchNBT(ItemStack stack) {
        return stack.m_41698_("PowahWrenchNBT");
    }
}

