/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.lib.logistics.inventory.slot.ITexturedSlot;

public class AbstractContainerScreen<C extends AbstractContainer>
extends net.minecraft.client.gui.screens.inventory.AbstractContainerScreen<C> {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final Texture backGround;
    @Nullable
    protected Runnable delayedClick;
    protected int clickDelay;

    public AbstractContainerScreen(C container, Inventory inv, Component title, Texture backGround) {
        super(container, inv, title);
        this.backGround = backGround;
        this.f_97726_ = backGround.getWidth();
        this.f_97727_ = backGround.getHeight();
    }

    public void setDelayedClick(int delay, @Nullable Runnable delayedClick) {
        this.clickDelay = delay;
        this.delayedClick = delayedClick;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.delayedClick != null && this.clickDelay >= 0) {
            --this.clickDelay;
            if (this.clickDelay == 0) {
                this.delayedClick.run();
                this.delayedClick = null;
            }
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrix, partialTicks, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.drawForeground(matrix, mouseX, mouseY);
    }

    protected void m_7025_(PoseStack matrix, int mouseX, int mouseY) {
        super.m_7025_(matrix, mouseX, mouseY);
        for (Widget iWidget : this.f_169369_) {
            AbstractWidget widget;
            if (!(iWidget instanceof AbstractWidget) || !(widget = (AbstractWidget)iWidget).m_198029_()) continue;
            widget.m_7428_(matrix, mouseX, mouseY);
            return;
        }
    }

    protected void drawBackground(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.backGround.draw(matrix, this.f_97735_, this.f_97736_);
    }

    protected void drawForeground(PoseStack matrix, int mouseX, int mouseY) {
        this.drawTitle(matrix, 0, 0);
    }

    protected void drawTitle(PoseStack matrix, int x, int y) {
        String title = this.f_96539_.getString();
        int width = this.f_96547_.m_92895_(title);
        this.f_96547_.m_92750_(matrix, title, (float)(x + this.f_97726_ / 2 - width / 2), (float)y - 14.0f, 0x999999);
    }

    public void m_97799_(PoseStack matrixStack, Slot slot) {
        if (slot instanceof ITexturedSlot) {
            ITexturedSlot base = (ITexturedSlot)slot;
            int x = slot.f_40220_;
            int y = slot.f_40221_;
            base.getBackground2().draw(matrixStack, x, y);
            if (!slot.m_6657_()) {
                RenderSystem.m_69478_();
                RenderSystem.m_69478_();
                base.getOverlay().draw(matrixStack, x, y);
                RenderSystem.m_69461_();
            }
        }
        super.m_97799_(matrixStack, slot);
    }

    public void bindTexture(ResourceLocation guiTexture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
    }

    public boolean isMouseOver(double mouseX, double mouseY, int w, int h) {
        return mouseX >= (double)this.f_97735_ && mouseY >= (double)this.f_97736_ && mouseX < (double)(this.f_97735_ + w) && mouseY < (double)(this.f_97736_ + h);
    }

    public List<Rect2i> getExtraAreas() {
        return new ArrayList<Rect2i>();
    }

    protected Rect2i toRectangle2d(int x, int y, Texture texture) {
        return new Rect2i(x, y, texture.getWidth(), texture.getHeight());
    }
}

