/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.utils.ChunkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.TickingBlockEntity;

public class Statistics {
    private final MinecraftServer server;

    public Statistics(MinecraftServer server) {
        this.server = server;
    }

    public static Statistics getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).getStatistics();
    }

    public List<Entity> getAllEntities() {
        return this.getAll(ServerLevel::m_8583_);
    }

    public List<TickingBlockEntity> getAllBlockEntities() {
        return this.getAll(level -> level.f_151512_);
    }

    public Map<String, Integer> getEntitiesByType(Iterable<Entity> entities) {
        return this.getByType(entities, entity -> EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    }

    public Map<String, Integer> getBlockEntitiesByType(Iterable<TickingBlockEntity> blockEntities) {
        return this.getByType(blockEntities, TickingBlockEntity::m_142280_);
    }

    public Map<String, Integer> getEntitiesByPlayer(Iterable<ServerPlayer> players) {
        return this.getByPlayer(players, this::getEntitiesNear);
    }

    public Map<String, Integer> getBlockEntitiesByPlayer(Iterable<ServerPlayer> players) {
        return this.getByPlayer(players, this::getBlockEntitiesNear);
    }

    private <T> List<T> getAll(Function<ServerLevel, Iterable<T>> function) {
        ObjectArrayList list = new ObjectArrayList();
        for (ServerLevel level : this.server.m_129785_()) {
            Iterables.addAll((Collection)list, function.apply(level));
        }
        return list;
    }

    private <T> Map<String, Integer> getByType(Iterable<T> iterable, Function<T, String> function) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (T value : iterable) {
            map.addTo((Object)function.apply(value), 1);
        }
        return map;
    }

    private Map<String, Integer> getByPlayer(Iterable<ServerPlayer> players, Function<ServerPlayer, List<?>> function) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (ServerPlayer player : players) {
            map.put((Object)player.m_6302_(), function.apply(player).size());
        }
        return map;
    }

    public List<Entity> getEntitiesNear(ServerPlayer player) {
        ObjectArrayList list = new ObjectArrayList();
        for (Entity entity : player.m_9236_().m_8583_()) {
            if (!this.isNearby((Player)player, entity.m_146902_())) continue;
            list.add(entity);
        }
        return list;
    }

    public List<TickingBlockEntity> getBlockEntitiesNear(ServerPlayer player) {
        ObjectArrayList list = new ObjectArrayList();
        for (TickingBlockEntity blockEntity : player.f_19853_.f_151512_) {
            BlockPos pos = blockEntity.m_142689_();
            if (pos == null || !this.isNearby((Player)player, new ChunkPos(pos))) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public int getChunkCount(boolean onlyLoaded) {
        int count = 0;
        for (ServerLevel level : this.server.m_129785_()) {
            if (onlyLoaded) {
                for (ChunkHolder holder : level.m_7726_().f_8325_.f_140130_.values()) {
                    if (!ChunkManager.hasChunk(holder)) continue;
                    ++count;
                }
                continue;
            }
            count += level.m_7726_().m_8482_();
        }
        return count;
    }

    private boolean isNearby(Player player, ChunkPos pos) {
        return (double)player.m_146902_().m_45594_(pos) <= DynamicSetting.VIEW_DISTANCE.get();
    }
}

