/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.turtle;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.UpgradeManager;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public final class TurtleUpgradeModellers {
    private static final TurtleUpgradeModeller<ITurtleUpgrade> NULL_TURTLE_MODELLER = (upgrade, turtle, side) -> new TransformedModel(Minecraft.m_91087_().m_91304_().m_119409_(), Transformation.m_121093_());
    private static final Map<TurtleUpgradeSerialiser<?>, TurtleUpgradeModeller<?>> turtleModels = new ConcurrentHashMap();
    private static final WeakHashMap<ITurtleUpgrade, TurtleUpgradeModeller<?>> modelCache = new WeakHashMap();

    private TurtleUpgradeModellers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ITurtleUpgrade> void register(@Nonnull TurtleUpgradeSerialiser<T> serialiser, @Nonnull TurtleUpgradeModeller<T> modeller) {
        Map<TurtleUpgradeSerialiser<?>, TurtleUpgradeModeller<?>> map = turtleModels;
        synchronized (map) {
            if (turtleModels.containsKey(serialiser)) {
                throw new IllegalStateException("Modeller already registered for serialiser");
            }
            turtleModels.put(serialiser, modeller);
        }
    }

    public static TransformedModel getModel(@Nonnull ITurtleUpgrade upgrade, @Nullable ITurtleAccess access, @Nonnull TurtleSide side) {
        TurtleUpgradeModeller modeller = modelCache.computeIfAbsent(upgrade, TurtleUpgradeModellers::getModeller);
        return modeller.getModel(upgrade, access, side);
    }

    private static TurtleUpgradeModeller<?> getModeller(ITurtleUpgrade upgradeA) {
        UpgradeManager.UpgradeWrapper<TurtleUpgradeSerialiser<?>, ITurtleUpgrade> wrapper = TurtleUpgrades.instance().getWrapper(upgradeA);
        if (wrapper == null) {
            return NULL_TURTLE_MODELLER;
        }
        TurtleUpgradeModeller<?> modeller = turtleModels.get(wrapper.serialiser());
        return modeller == null ? NULL_TURTLE_MODELLER : modeller;
    }
}

