/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNetworkChange;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class WiredModemElement
implements IWiredElement {
    private final IWiredNode node = ComputerCraftAPI.createWiredNodeForElement(this);
    private final Map<String, IPeripheral> remotePeripherals = new HashMap<String, IPeripheral>();

    @Override
    @Nonnull
    public IWiredNode getNode() {
        return this.node;
    }

    @Override
    @Nonnull
    public String getSenderID() {
        return "modem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void networkChanged(@Nonnull IWiredNetworkChange change) {
        Map<String, IPeripheral> map = this.remotePeripherals;
        synchronized (map) {
            this.remotePeripherals.keySet().removeAll(change.peripheralsRemoved().keySet());
            for (String string : change.peripheralsRemoved().keySet()) {
                this.detachPeripheral(string);
            }
            for (Map.Entry entry : change.peripheralsAdded().entrySet()) {
                this.attachPeripheral((String)entry.getKey(), (IPeripheral)entry.getValue());
            }
            this.remotePeripherals.putAll(change.peripheralsAdded());
        }
    }

    public Map<String, IPeripheral> getRemotePeripherals() {
        return this.remotePeripherals;
    }

    protected abstract void attachPeripheral(String var1, IPeripheral var2);

    protected abstract void detachPeripheral(String var1);
}

