/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.magnet.IMagnet;
import com.mrbysco.forcecraft.client.KeybindHandler;
import com.mrbysco.forcecraft.client.gui.belt.ForceBeltScreen;
import com.mrbysco.forcecraft.client.gui.card.ItemCardScreen;
import com.mrbysco.forcecraft.client.gui.engine.ForceEngineScreen;
import com.mrbysco.forcecraft.client.gui.furnace.ForceFurnaceScreen;
import com.mrbysco.forcecraft.client.gui.infuser.InfuserScreen;
import com.mrbysco.forcecraft.client.gui.pack.ForcePackScreen;
import com.mrbysco.forcecraft.client.gui.spoils.SpoilsBagScreen;
import com.mrbysco.forcecraft.client.model.CreeperTotModel;
import com.mrbysco.forcecraft.client.model.EnderTotModel;
import com.mrbysco.forcecraft.client.model.FairyModel;
import com.mrbysco.forcecraft.client.renderer.BlueChuChuRenderer;
import com.mrbysco.forcecraft.client.renderer.ColdChickenRenderer;
import com.mrbysco.forcecraft.client.renderer.ColdCowRenderer;
import com.mrbysco.forcecraft.client.renderer.ColdPigRenderer;
import com.mrbysco.forcecraft.client.renderer.CreeperTotRenderer;
import com.mrbysco.forcecraft.client.renderer.EnderTotRenderer;
import com.mrbysco.forcecraft.client.renderer.FairyRenderer;
import com.mrbysco.forcecraft.client.renderer.ForceArrowRenderer;
import com.mrbysco.forcecraft.client.renderer.GoldChuChuRenderer;
import com.mrbysco.forcecraft.client.renderer.GreenChuChuRenderer;
import com.mrbysco.forcecraft.client.renderer.RedChuChuRenderer;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientHandler {
    public static final ModelLayerLocation CREEPER_TOT = new ModelLayerLocation(new ResourceLocation("forcecraft", "creeper_tot"), "main");
    public static final ModelLayerLocation FAIRY = new ModelLayerLocation(new ResourceLocation("forcecraft", "fairy"), "main");
    public static final ModelLayerLocation ENDERTOT = new ModelLayerLocation(new ResourceLocation("forcecraft", "endertot"), "main");

    public static void onClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.FORCE_FURNACE.get()), ForceFurnaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.INFUSER.get()), InfuserScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.FORCE_BELT.get()), ForceBeltScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.FORCE_PACK.get()), ForcePackScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.SPOILS_BAG.get()), SpoilsBagScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.ITEM_CARD.get()), ItemCardScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ForceMenus.FORCE_ENGINE.get()), ForceEngineScreen::new);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ForceFluids.FORCE_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get()), (RenderType)RenderType.m_110466_());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ForceRegistry.MAGNET_GLOVE.get()), (ResourceLocation)new ResourceLocation("active"), (stack, world, livingEntity, i) -> {
                IMagnet magnetCap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null);
                return magnetCap != null && magnetCap.isActivated() ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)ForceRegistry.ENTITY_FLASK.get()), (ResourceLocation)new ResourceLocation("captured"), (stack, world, livingEntity, i) -> stack.m_41782_() && stack.m_41783_().m_128441_("StoredEntity") ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ForceRegistry.BACONATOR.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, world, livingEntity, i) -> stack.m_41782_() && stack.m_41783_().m_128441_("forcecraft:hasItems") ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ForceRegistry.FORCE_PACK.get()), (ResourceLocation)new ResourceLocation("color"), (stack, world, livingEntity, i) -> stack.m_41782_() && stack.m_41783_().m_128441_("Color") ? 0.0625f * (float)stack.m_41783_().m_128451_("Color") : 0.9375f);
            ItemProperties.register((Item)((Item)ForceRegistry.FORCE_BELT.get()), (ResourceLocation)new ResourceLocation("color"), (stack, world, livingEntity, i) -> stack.m_41782_() && stack.m_41783_().m_128441_("Color") ? 0.0625f * (float)stack.m_41783_().m_128451_("Color") : 0.9375f);
            ItemProperties.register((Item)((Item)ForceRegistry.FORCE_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return livingEntity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)ForceRegistry.FORCE_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f);
        });
    }

    public static void registerKeymapping(RegisterKeyMappingsEvent event) {
        event.register(KeybindHandler.KEY_OPEN_HOTBAR_PACK);
        event.register(KeybindHandler.KEY_OPEN_HOTBAR_BELT);
        event.register(KeybindHandler.KEY_QUICK_USE_1);
        event.register(KeybindHandler.KEY_QUICK_USE_2);
        event.register(KeybindHandler.KEY_QUICK_USE_3);
        event.register(KeybindHandler.KEY_QUICK_USE_4);
        event.register(KeybindHandler.KEY_QUICK_USE_5);
        event.register(KeybindHandler.KEY_QUICK_USE_6);
        event.register(KeybindHandler.KEY_QUICK_USE_7);
        event.register(KeybindHandler.KEY_QUICK_USE_8);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CREEPER_TOT, CreeperTotModel::createBodyLayer);
        event.registerLayerDefinition(ENDERTOT, EnderTotModel::createBodyLayer);
        event.registerLayerDefinition(FAIRY, FairyModel::createBodyLayer);
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ForceEntities.NON_BURNABLE_ITEM.get(), ItemEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.COLD_CHICKEN.get(), ColdChickenRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.COLD_COW.get(), ColdCowRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.COLD_PIG.get(), ColdPigRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.RED_CHU_CHU.get(), RedChuChuRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.GREEN_CHU_CHU.get(), GreenChuChuRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.BLUE_CHU_CHU.get(), BlueChuChuRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.GOLD_CHU_CHU.get(), GoldChuChuRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.FAIRY.get(), FairyRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.CREEPER_TOT.get(), CreeperTotRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.ENDER_TOT.get(), EnderTotRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.ANGRY_ENDERMAN.get(), EndermanRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.FORCE_ARROW.get(), ForceArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ForceEntities.FORCE_FLASK.get(), ThrownItemRenderer::new);
    }

    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0 || tintIndex == 1) {
                if (stack.m_41782_() && stack.m_41783_().m_128425_("StoredEntity", 8)) {
                    ResourceLocation id = new ResourceLocation(stack.m_41783_().m_128461_("StoredEntity"));
                    SpawnEggItem info = SpawnEggItem.m_43213_((EntityType)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id)));
                    if (info != null) {
                        return tintIndex == 0 ? info.m_43211_(0) : info.m_43211_(1);
                    }
                    return tintIndex == 0 ? 10489616 : (tintIndex == 1 ? 951412 : 0xFFFFFF);
                }
                return 0xFFFFFF;
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ForceRegistry.ENTITY_FLASK.get()});
    }
}

