/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.config.ECConfig;

public class DiffuserBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity {
    private boolean hasDiffused;
    private final RuneHandler runeHandler;
    private ISingleElementStorage containerCache;

    public DiffuserBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.DIFFUSER, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.diffuserMaxRunes.get(), this::m_6596_);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.hasDiffused = compound.m_128471_("has_diffused");
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("has_diffused", this.hasDiffused);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DiffuserBlockEntity diffuser) {
        ISingleElementStorage container = diffuser.getContainer();
        AtomicInteger amount = new AtomicInteger((Integer)ECConfig.COMMON.diffuserDiffusionAmount.get());
        diffuser.hasDiffused = false;
        if (container != null && !container.isEmpty()) {
            diffuser.m_58904_().m_45933_(null, new AABB(diffuser.m_58899_()).m_82400_((double)((Integer)ECConfig.COMMON.diffuserRange.get()).intValue())).stream().map(ElementStorageHelper::get).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).forEach(storage -> {
                if (!container.isEmpty() && amount.get() > 0 && container.transferTo((IElementStorage)storage, container.getElementType(), diffuser.runeHandler.getTransferSpeed(amount.get()), Math.min(1.0f, diffuser.runeHandler.getElementPreservation())) > 0) {
                    diffuser.hasDiffused = true;
                }
            });
        }
    }

    public boolean hasDiffused() {
        return this.hasDiffused;
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.RUNE_HANDLE) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

