/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.input;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.input.ECKeyMappings;
import sirttas.elementalcraft.spell.ChangeSpellMessage;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.tag.ECTags;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class InputHandler {
    private InputHandler() {
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6144_()) {
            InputHandler.getFirstSpellCastTool(EntityHelper.handStream((Player)player)).ifPresent(stack -> {
                int index = SpellHelper.getSelected(stack);
                if (event.getScrollDelta() > 0.0) {
                    InputHandler.setSelectedSpell(player, stack, index - 1);
                    event.setCanceled(true);
                } else if (event.getScrollDelta() < 0.0) {
                    InputHandler.setSelectedSpell(player, stack, index + 1);
                    event.setCanceled(true);
                }
            });
        }
    }

    @Nonnull
    private static Optional<ItemStack> getFirstSpellCastTool(Stream<ItemStack> player) {
        return player.filter(i -> i.m_204117_(ECTags.Items.SPELL_CAST_TOOLS)).findFirst();
    }

    private static void setSelectedSpell(LocalPlayer player, ItemStack stack, int i) {
        SpellHelper.setSelected(stack, i);
        player.m_5661_(SpellHelper.getSpell(stack).getDisplayName(), true);
        new ChangeSpellMessage(i).send();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.CLIENT && (player = event.player) instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            if (event.player == Minecraft.m_91087_().f_91074_ && event.phase == TickEvent.Phase.END) {
                InputHandler.getFirstSpellCastTool(EntityHelper.handStream((Player)localPlayer)).ifPresent(stack -> {
                    int index = 0;
                    for (KeyMapping key : ECKeyMappings.CHANGE_TO_SPELL) {
                        if (!key.m_90862_() && key.m_90859_() && SpellHelper.getSpellsAsMap(stack).size() > index) {
                            InputHandler.setSelectedSpell(localPlayer, stack, index);
                        }
                        ++index;
                    }
                });
            }
        }
    }
}

