/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle.element;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public class ElementTypeParticleData
implements ParticleOptions,
IElementTypeProvider {
    private final ElementType elementType;
    private final ParticleType<ElementTypeParticleData> type;
    private ResourceLocation key;
    public static final ParticleOptions.Deserializer<ElementTypeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ElementTypeParticleData>(){

        @Nonnull
        public ElementTypeParticleData fromCommand(@Nonnull ParticleType<ElementTypeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ElementTypeParticleData(type, ElementType.byName(reader.readString()));
        }

        @Nonnull
        public ElementTypeParticleData fromNetwork(@Nonnull ParticleType<ElementTypeParticleData> type, FriendlyByteBuf buffer) {
            return new ElementTypeParticleData(type, ElementType.byName(buffer.m_130277_()));
        }
    };

    public ElementTypeParticleData(ParticleType<ElementTypeParticleData> type, ElementType elementType) {
        this.elementType = elementType;
        this.type = type;
    }

    @Nonnull
    public ParticleType<ElementTypeParticleData> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.elementType.m_7912_());
    }

    @Nonnull
    public String m_5942_() {
        return this.getKey().toString() + " " + this.getElementType().m_7912_();
    }

    private ResourceLocation getKey() {
        if (this.key == null) {
            this.key = ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_());
        }
        return this.key;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public static Codec<ElementTypeParticleData> getCodec(ParticleType<ElementTypeParticleData> particleType) {
        return ElementType.CODEC.xmap(e -> new ElementTypeParticleData(particleType, (ElementType)e), ElementTypeParticleData::getElementType);
    }

    public static ParticleType<ElementTypeParticleData> createParticleType(boolean alwaysShow) {
        return new ParticleType<ElementTypeParticleData>(alwaysShow, DESERIALIZER){

            @Nonnull
            public Codec<ElementTypeParticleData> m_7652_() {
                return ElementTypeParticleData.getCodec(this);
            }
        };
    }
}

