/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.crafting;

import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public interface IMachineRecipe {
    public ResourceLocation getRecipeId();

    public ResourceLocation getMachineId();

    public int getRecipeTime();

    public List<IRequirement<?>> getRequirements();

    public List<IRequirement<?>> getJeiRequirements();

    default public List<IRequirement<?>> getDisplayInfoRequirements() {
        if (this.getJeiRequirements().isEmpty()) {
            return this.getRequirements();
        }
        return this.getJeiRequirements();
    }

    default public List<IJEIIngredientRequirement<?>> getJEIIngredientRequirements() {
        if (this.getJeiRequirements().isEmpty()) {
            return this.getRequirements().stream().filter(requirement -> requirement instanceof IJEIIngredientRequirement).map(requirement -> (IJEIIngredientRequirement)((Object)requirement)).collect(Collectors.toList());
        }
        return this.getJeiRequirements().stream().filter(requirement -> requirement instanceof IJEIIngredientRequirement).map(requirement -> (IJEIIngredientRequirement)((Object)requirement)).collect(Collectors.toList());
    }

    public int getPriority();

    public int getJeiPriority();

    public boolean shouldResetOnError();

    public boolean showInJei();
}

