/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.RegisterGuiElementWidgetSupplierEvent;
import fr.frinn.custommachinery.api.integration.jei.RegisterGuiElementJEIRendererEvent;
import fr.frinn.custommachinery.api.integration.jei.RegisterWidgetToJeiIngredientGetterEvent;
import fr.frinn.custommachinery.client.integration.jei.FluidIngredientGetter;
import fr.frinn.custommachinery.client.integration.jei.element.EnergyGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.ExperienceGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.FluidGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.FuelGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.ProgressGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.SlotGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.TextGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.TextureGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.client.render.element.BarGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ButtonGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ConfigGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.DumpGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.EmptyGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.EnergyGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ExperienceGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.FluidGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.FuelGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.PlayerInventoryGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ProgressGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ResetGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.SlotGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.StatusGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.TextGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.TextureGuiElementWidget;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.client.screen.creator.MachineCreationScreen;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import fr.frinn.custommachinery.impl.integration.jei.GuiElementJEIRendererRegistry;
import fr.frinn.custommachinery.impl.integration.jei.WidgetToJeiIngredientRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    public static void init() {
        ClientTooltipEvent.ITEM.register(ClientHandler::onItemTooltip);
        LifecycleEvent.SETUP.register(ClientHandler::clientSetup);
        RegisterGuiElementWidgetSupplierEvent.EVENT.register(ClientHandler::registerGuiElementWidgets);
        RegisterGuiElementJEIRendererEvent.EVENT.register(ClientHandler::registerGuiElementJEIRenderers);
        RegisterWidgetToJeiIngredientGetterEvent.EVENT.register(ClientHandler::registerWidgetToJeiIngredientGetters);
    }

    private static void onItemTooltip(ItemStack stack, List<Component> lines, TooltipFlag flag) {
        CustomMachinery.UPGRADES.getUpgradesForItem(stack.m_41720_()).forEach(upgrade -> {
            block3: {
                block2: {
                    lines.addAll(upgrade.getTooltips());
                    if (Screen.m_96637_()) break block2;
                    if (!Screen.m_96638_()) break block3;
                }
                upgrade.getModifiers().stream().map(RecipeModifier::getTooltip).forEach(lines::add);
            }
        });
    }

    private static void clientSetup() {
        RenderTypeRegistry.register((RenderType)ClientHandler.getRenderType(((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).renderType), (Block[])new Block[]{(Block)Registration.CUSTOM_MACHINE_BLOCK.get()});
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> RenderTypeRegistry.register((RenderType)ClientHandler.getRenderType(block.renderType), (Block[])new Block[]{block}));
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)Registration.CUSTOM_MACHINE_CONTAINER.get()), CustomMachineScreen::new);
        GuiElementWidgetSupplierRegistry.init();
        if (Platform.isModLoaded((String)"jei")) {
            GuiElementJEIRendererRegistry.init();
            WidgetToJeiIngredientRegistry.init();
        }
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)Registration.CUSTOM_MACHINE_TILE.get()), CustomMachineRenderer::new);
        ColorHandlerRegistry.registerBlockColors(ClientHandler::blockColor, (Block[])new Block[]{(Block)Registration.CUSTOM_MACHINE_BLOCK.get()});
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> ColorHandlerRegistry.registerBlockColors(ClientHandler::blockColor, (Block[])new Block[]{block}));
        ItemLike[] itemLikeArray = new ItemLike[1];
        itemLikeArray[0] = () -> Registration.CUSTOM_MACHINE_ITEM.get();
        ColorHandlerRegistry.registerItemColors(ClientHandler::itemColor, (ItemLike[])itemLikeArray);
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> ColorHandlerRegistry.registerItemColors(ClientHandler::itemColor, (ItemLike[])new ItemLike[]{block}));
    }

    private static void registerGuiElementWidgets(RegisterGuiElementWidgetSupplierEvent event) {
        event.register((GuiElementType)Registration.ENERGY_GUI_ELEMENT.get(), EnergyGuiElementWidget::new);
        event.register((GuiElementType)Registration.FLUID_GUI_ELEMENT.get(), FluidGuiElementWidget::new);
        event.register((GuiElementType)Registration.PLAYER_INVENTORY_GUI_ELEMENT.get(), PlayerInventoryGuiElementWidget::new);
        event.register((GuiElementType)Registration.PROGRESS_GUI_ELEMENT.get(), ProgressGuiElementWidget::new);
        event.register((GuiElementType)Registration.SLOT_GUI_ELEMENT.get(), SlotGuiElementWidget::new);
        event.register((GuiElementType)Registration.STATUS_GUI_ELEMENT.get(), StatusGuiElementWidget::new);
        event.register((GuiElementType)Registration.TEXTURE_GUI_ELEMENT.get(), TextureGuiElementWidget::new);
        event.register((GuiElementType)Registration.TEXT_GUI_ELEMENT.get(), TextGuiElementWidget::new);
        event.register((GuiElementType)Registration.FUEL_GUI_ELEMENT.get(), FuelGuiElementWidget::new);
        event.register((GuiElementType)Registration.RESET_GUI_ELEMENT.get(), ResetGuiElementWidget::new);
        event.register((GuiElementType)Registration.DUMP_GUI_ELEMENT.get(), DumpGuiElementWidget::new);
        event.register((GuiElementType)Registration.CONFIG_GUI_ELEMENT.get(), ConfigGuiElementWidget::new);
        event.register((GuiElementType)Registration.BUTTON_GUI_ELEMENT.get(), ButtonGuiElementWidget::new);
        event.register((GuiElementType)Registration.EXPERIENCE_GUI_ELEMENT.get(), ExperienceGuiElementWidget::new);
        event.register((GuiElementType)Registration.BAR_GUI_ELEMENT.get(), BarGuiElementWidget::new);
        event.register((GuiElementType)Registration.EMPTY_GUI_ELEMENT.get(), EmptyGuiElementWidget::new);
    }

    private static void registerGuiElementJEIRenderers(RegisterGuiElementJEIRendererEvent event) {
        event.register((GuiElementType)Registration.ENERGY_GUI_ELEMENT.get(), new EnergyGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.FLUID_GUI_ELEMENT.get(), new FluidGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.FUEL_GUI_ELEMENT.get(), new FuelGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.PROGRESS_GUI_ELEMENT.get(), new ProgressGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.SLOT_GUI_ELEMENT.get(), new SlotGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.TEXT_GUI_ELEMENT.get(), new TextGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.TEXTURE_GUI_ELEMENT.get(), new TextureGuiElementJeiRenderer());
        event.register((GuiElementType)Registration.EXPERIENCE_GUI_ELEMENT.get(), new ExperienceGuiElementJeiRenderer());
    }

    private static void registerWidgetToJeiIngredientGetters(RegisterWidgetToJeiIngredientGetterEvent event) {
        event.register((GuiElementType)Registration.FLUID_GUI_ELEMENT.get(), new FluidIngredientGetter());
    }

    public static void openMachineLoadingScreen() {
        Minecraft.m_91087_().m_91152_((Screen)MachineCreationScreen.INSTANCE);
    }

    private static int blockColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
        if (level == null || pos == null) {
            return 0;
        }
        switch (tintIndex) {
            case 1: {
                return level.m_6171_(pos, BiomeColors.f_108791_);
            }
            case 2: {
                return level.m_6171_(pos, BiomeColors.f_108789_);
            }
            case 3: {
                return level.m_6171_(pos, BiomeColors.f_108790_);
            }
            case 4: {
                BlockEntity tile = level.m_7702_(pos);
                if (!(tile instanceof CustomMachineTile)) break;
                CustomMachineTile machineTile = (CustomMachineTile)tile;
                return machineTile.getAppearance().getColor();
            }
        }
        return 0xFFFFFF;
    }

    private static int itemColor(ItemStack stack, int tintIndex) {
        BlockState state = ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).m_49966_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return 0;
        }
        BlockPos pos = Minecraft.m_91087_().f_91074_.m_20183_();
        return Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, tintIndex);
    }

    @NotNull
    public static CustomMachineTile getClientSideCustomMachineTile(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.m_91087_().f_91073_ != null && (tile = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof CustomMachineTile) {
            return (CustomMachineTile)tile;
        }
        throw new IllegalStateException("Trying to open a Custom Machine container without clicking on a Custom Machine block");
    }

    public static void drawSizedString(Font font, PoseStack matrix, String string, int x, int y, int size, float maxScale, int color) {
        float stringSize = font.m_92895_(string);
        float scale = Math.min((float)size / stringSize, maxScale);
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, 0.0f);
        font.m_92883_(matrix, string, (float)x / scale, (float)y / scale, color);
        matrix.m_85849_();
    }

    public static void drawCenteredString(Font font, PoseStack matrix, String string, int x, int y, int color) {
        int width = font.m_92895_(string);
        Objects.requireNonNull(font);
        int height = 9;
        matrix.m_85836_();
        matrix.m_85837_((double)(-width) / 2.0, (double)(-height) / 2.0, 0.0);
        font.m_92883_(matrix, string, (float)x, (float)y, color);
        matrix.m_85849_();
    }

    public static void renderItemAndEffectsIntoGUI(PoseStack matrix, ItemStack stack, int x, int y) {
        boolean flag;
        matrix.m_85836_();
        ClientHandler.bindTexture(TextureAtlas.f_118259_);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_85837_((double)x, (double)y, (double)(100.0f + Minecraft.m_91087_().m_91291_().f_115093_));
        matrix.m_85837_(8.0, 8.0, 0.0);
        matrix.m_85841_(1.0f, -1.0f, 1.0f);
        matrix.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.m_91087_().m_91269_().m_110104_();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0);
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        RenderSystem.m_69465_();
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.GUI, false, matrix, (MultiBufferSource)irendertypebuffer$impl, 0xF000F0, OverlayTexture.f_118083_, model);
        irendertypebuffer$impl.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        RenderSystem.m_69461_();
        matrix.m_85849_();
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)x, (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        ClientHandler.drawHoveringText(poseStack, textLines, x, y, font);
    }

    public static void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y, Font font) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        screen.m_169388_(poseStack, textLines, Optional.empty(), x, y);
    }

    public static void renderSlotHighlight(PoseStack pose, int x, int y, int width, int height) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-2130706433);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public static void renderButtonHover(PoseStack pose, int x, int y, int width, int height) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        GuiComponent.m_93172_((PoseStack)pose, (int)(x + width - 1), (int)y, (int)(x + width), (int)(y + height), (int)FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + 1), (int)(y + height), (int)FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public static boolean isShiftKeyDown() {
        return Screen.m_96638_();
    }

    public static RenderType getRenderType(String renderType) {
        return switch (renderType) {
            case "solid" -> RenderType.m_110451_();
            case "cutout" -> RenderType.m_110463_();
            case "translucent" -> RenderType.m_110466_();
            default -> throw new IllegalArgumentException("Invalid render type: " + renderType);
        };
    }
}

