/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.collect.Lists;
import dev.architectury.registry.fuel.FuelRegistry;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.client.integration.jei.CMRecipeTypes;
import fr.frinn.custommachinery.client.integration.jei.CustomCraftRecipeCategory;
import fr.frinn.custommachinery.client.integration.jei.CustomMachineRecipeCategory;
import fr.frinn.custommachinery.client.integration.jei.DummyIngredientRenderer;
import fr.frinn.custommachinery.client.integration.jei.energy.EnergyIngredientHelper;
import fr.frinn.custommachinery.client.integration.jei.experience.ExperienceIngredientHelper;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.common.util.slot.FilterSlotItemComponent;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.WidgetToJeiIngredientRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CustomMachineryJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = new ResourceLocation("custommachinery", "jei_plugin");
    public static final List<ItemStack> FUEL_INGREDIENTS = Lists.newArrayList();

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)Registration.CUSTOM_MACHINE_ITEM.get()});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            if (machine.getProcessorTemplate().getType() == Registration.MACHINE_PROCESSOR.get()) {
                registry.addRecipeCategories(new IRecipeCategory[]{new CustomMachineRecipeCategory((CustomMachine)machine, CMRecipeTypes.create(id, CustomMachineRecipe.class), registry.getJeiHelpers())});
            } else if (machine.getProcessorTemplate().getType() == Registration.CRAFT_PROCESSOR.get()) {
                registry.addRecipeCategories(new IRecipeCategory[]{new CustomCraftRecipeCategory((CustomMachine)machine, CMRecipeTypes.create(id, CustomCraftRecipe.class), registry.getJeiHelpers())});
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Map<ResourceLocation, List<CustomMachineRecipe>> machineRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().filter(CustomMachineRecipe::showInJei).sorted(Comparators.JEI_PRIORITY_COMPARATOR.reversed()).collect(Collectors.groupingBy(CustomMachineRecipe::getMachineId));
        machineRecipes.forEach((id, list) -> {
            RecipeType<CustomMachineRecipe> type = CMRecipeTypes.machine(id);
            if (type != null) {
                registry.addRecipes(type, list);
            }
        });
        Map<ResourceLocation, List<CustomCraftRecipe>> craftRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.CUSTOM_CRAFT_RECIPE.get()).stream().filter(CustomCraftRecipe::showInJei).sorted(Comparators.JEI_PRIORITY_COMPARATOR.reversed()).collect(Collectors.groupingBy(CustomCraftRecipe::getMachineId));
        craftRecipes.forEach((id, list) -> {
            RecipeType<CustomCraftRecipe> type = CMRecipeTypes.craft(id);
            if (type != null) {
                registry.addRecipes(type, list);
            }
        });
        registry.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK).stream().filter(stack -> FuelRegistry.get((ItemStack)stack) > 0).forEach(FUEL_INGREDIENTS::add);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(CustomIngredientTypes.ENERGY, new ArrayList(), (IIngredientHelper)new EnergyIngredientHelper(), new DummyIngredientRenderer());
        registry.register(CustomIngredientTypes.EXPERIENCE, new ArrayList(), (IIngredientHelper)new ExperienceIngredientHelper(), new DummyIngredientRenderer());
    }

    public void registerGuiHandlers(final IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CustomMachineScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CustomMachineScreen>(){

            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(CustomMachineScreen screen, double mouseX, double mouseY) {
                return screen.getElementUnderMouse(mouseX, mouseY).flatMap(widget -> Optional.ofNullable(WidgetToJeiIngredientRegistry.getIngredient(widget, mouseX, mouseY, registration.getJeiHelpers())));
            }

            public Collection<IGuiClickableArea> getGuiClickableAreas(CustomMachineScreen screen, double mouseX, double mouseY) {
                List<IGuiElement> elements = screen.getTile().getGuiElements();
                return elements.stream().filter(element -> element instanceof ProgressBarGuiElement).map(element -> {
                    ProgressBarGuiElement progress = (ProgressBarGuiElement)element;
                    int posX = progress.getX();
                    int posY = progress.getY();
                    boolean invertAxis = progress.getEmptyTexture().equals((Object)ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && progress.getFilledTexture().equals((Object)ProgressBarGuiElement.BASE_FILLED_TEXTURE) && progress.getDirection() != ProgressBarGuiElement.Orientation.RIGHT && progress.getDirection() != ProgressBarGuiElement.Orientation.LEFT;
                    int width = invertAxis ? progress.getHeight() : progress.getWidth();
                    int height = invertAxis ? progress.getWidth() : progress.getHeight();
                    return CustomMachineryJEIPlugin.createBasic(posX, posY, width, height, screen.getMachine().getId());
                }).toList();
            }
        });
        registration.addGhostIngredientHandler(CustomMachineScreen.class, (IGhostIngredientHandler)new IGhostIngredientHandler<CustomMachineScreen>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(CustomMachineScreen gui, I ingredient, boolean doStart) {
                return Collections.emptyList();
            }

            public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final CustomMachineScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
                Object object = ingredient.getIngredient();
                if (object instanceof ItemStack) {
                    final ItemStack stack = (ItemStack)object;
                    return ((CustomMachineContainer)screen.m_6262_()).f_38839_.stream().filter(slot -> slot instanceof FilterSlotItemComponent).map(slot -> {
                        final FilterSlotItemComponent filterSlot = (FilterSlotItemComponent)((Object)slot);
                        return new IGhostIngredientHandler.Target<I>(){

                            public Rect2i getArea() {
                                return new Rect2i(screen.getX() + filterSlot.f_40220_, screen.getY() + filterSlot.f_40221_, 16, 16);
                            }

                            public void accept(I ingredient) {
                                filterSlot.setFromClient(stack);
                            }
                        };
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        CustomMachinery.MACHINES.forEach((id, machine) -> machine.getRecipeIds().forEach(recipeId -> {
            RecipeType<? extends IMachineRecipe> type = CMRecipeTypes.fromID(recipeId);
            if (type != null) {
                List<ResourceLocation> catalysts = machine.getCatalysts();
                if (!catalysts.contains(id)) {
                    registration.addRecipeCatalyst(CustomMachineItem.makeMachineItem(id), new RecipeType[]{type});
                }
                machine.getCatalysts().forEach(catalyst -> {
                    if (CustomMachinery.MACHINES.containsKey(catalyst)) {
                        registration.addRecipeCatalyst(CustomMachineItem.makeMachineItem(catalyst), new RecipeType[]{type});
                    } else if (Registration.REGISTRIES.get(Registry.f_122904_).contains(catalyst)) {
                        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.REGISTRIES.get(Registry.f_122904_).get(catalyst)), new RecipeType[]{type});
                    } else {
                        ICustomMachineryAPI.INSTANCE.logger().error("Invalid catalyst '{}' for machine '{}'. Not a machine or item id", catalyst, id);
                    }
                });
            }
        }));
    }

    private static IGuiClickableArea createBasic(int xPos, int yPos, int width, int height, ResourceLocation id) {
        final Rect2i area = new Rect2i(xPos, yPos, width, height);
        final ItemStack stack = CustomMachineItem.makeMachineItem(id);
        return new IGuiClickableArea(){

            public Rect2i getArea() {
                return area;
            }

            public void onClick(IFocusFactory factory, IRecipesGui recipesGui) {
                recipesGui.show(factory.createFocus(RecipeIngredientRole.CATALYST, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack));
            }
        };
    }
}

