/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.element;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.render.element.ProgressGuiElementWidget;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ProgressGuiElementJeiRenderer
implements IJEIElementRenderer<ProgressBarGuiElement> {
    @Override
    public void renderElementInJEI(PoseStack matrix, ProgressBarGuiElement element, IMachineRecipe recipe, int mouseX, int mouseY) {
        int posX = element.getX();
        int posY = element.getY();
        int width = element.getWidth();
        int height = element.getHeight();
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        int filledWidth = 0;
        int filledHeight = 0;
        if (recipe.getRecipeTime() > 0) {
            filledWidth = (int)((double)width * Mth.m_14008_((double)Mth.m_184637_((float)((float)(Minecraft.m_91087_().f_91073_.m_46467_() % (long)recipe.getRecipeTime()) / (float)recipe.getRecipeTime()), (float)element.getStart(), (float)element.getEnd(), (float)0.0f, (float)1.0f), (double)0.0, (double)1.0));
            filledHeight = (int)((double)height * Mth.m_14008_((double)Mth.m_184637_((float)((float)(Minecraft.m_91087_().f_91073_.m_46467_() % (long)recipe.getRecipeTime()) / (float)recipe.getRecipeTime()), (float)element.getStart(), (float)element.getEnd(), (float)0.0f, (float)1.0f), (double)0.0, (double)1.0));
        }
        ClientHandler.bindTexture(element.getEmptyTexture());
        if (element.getEmptyTexture().equals((Object)ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && element.getFilledTexture().equals((Object)ProgressBarGuiElement.BASE_FILLED_TEXTURE)) {
            matrix.m_85836_();
            ProgressGuiElementWidget.rotate(matrix, element.getDirection(), posX, posY, width, height);
            GuiComponent.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
            ClientHandler.bindTexture(element.getFilledTexture());
            GuiComponent.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)filledWidth, (int)height, (int)width, (int)height);
            matrix.m_85849_();
        } else {
            GuiComponent.m_93133_((PoseStack)matrix, (int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
            ClientHandler.bindTexture(element.getFilledTexture());
            switch (element.getDirection()) {
                case RIGHT: {
                    GuiComponent.m_93133_((PoseStack)matrix, (int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)filledWidth, (int)height, (int)width, (int)height);
                    break;
                }
                case LEFT: {
                    GuiComponent.m_93133_((PoseStack)matrix, (int)(posX + width - filledWidth), (int)posY, (float)(width - filledWidth), (float)0.0f, (int)filledWidth, (int)height, (int)width, (int)height);
                    break;
                }
                case TOP: {
                    GuiComponent.m_93133_((PoseStack)matrix, (int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)width, (int)filledHeight, (int)width, (int)height);
                    break;
                }
                case BOTTOM: {
                    GuiComponent.m_93133_((PoseStack)matrix, (int)posX, (int)(posY + height - filledHeight), (float)0.0f, (float)(height - filledHeight), (int)width, (int)filledHeight, (int)width, (int)height);
                }
            }
        }
    }

    @Override
    public boolean isHoveredInJei(ProgressBarGuiElement element, int posX, int posY, int mouseX, int mouseY) {
        boolean invertAxis = element.getEmptyTexture().equals((Object)ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && element.getFilledTexture().equals((Object)ProgressBarGuiElement.BASE_FILLED_TEXTURE) && element.getDirection() != ProgressBarGuiElement.Orientation.RIGHT && element.getDirection() != ProgressBarGuiElement.Orientation.LEFT;
        int width = invertAxis ? element.getHeight() : element.getWidth();
        int height = invertAxis ? element.getWidth() : element.getHeight();
        return mouseX >= posX && mouseX <= posX + width && mouseY >= posY && mouseY <= posY + height;
    }

    @Override
    public List<Component> getJEITooltips(ProgressBarGuiElement element, IMachineRecipe recipe) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (recipe.getRecipeTime() > 0) {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.recipe.time", (Object[])new Object[]{recipe.getRecipeTime()}));
        } else {
            tooltips.add((Component)Component.m_237115_((String)"custommachinery.jei.recipe.instant"));
        }
        if (!CMConfig.get().needAdvancedInfoForRecipeID || Minecraft.m_91087_().f_91066_.f_92125_) {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.recipe.id", (Object[])new Object[]{recipe.getRecipeId().toString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltips;
    }
}

