/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.energy;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.integration.jei.JEIIngredientRenderer;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.EnergyGuiElement;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class EnergyJEIIngredientRenderer
extends JEIIngredientRenderer<Energy, EnergyGuiElement> {
    public EnergyJEIIngredientRenderer(EnergyGuiElement element) {
        super(element);
    }

    @Override
    public IIngredientType<Energy> getType() {
        return CustomIngredientTypes.ENERGY;
    }

    public int getWidth() {
        return ((EnergyGuiElement)this.element).getWidth() - 2;
    }

    public int getHeight() {
        return ((EnergyGuiElement)this.element).getHeight() - 2;
    }

    public void render(PoseStack matrix, @Nullable Energy ingredient) {
        int width = ((EnergyGuiElement)this.element).getWidth();
        int height = ((EnergyGuiElement)this.element).getHeight();
        ClientHandler.bindTexture(((EnergyGuiElement)this.element).getFilledTexture());
        GuiComponent.m_93133_((PoseStack)matrix, (int)-1, (int)-1, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public List<Component> getTooltip(Energy ingredient, TooltipFlag iTooltipFlag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        String amount = Utils.format(ingredient.getAmount());
        Component unit = PlatformHelper.energy().unit();
        if (ingredient.isPerTick()) {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.energy.pertick", (Object[])new Object[]{amount, unit}));
        } else {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.energy", (Object[])new Object[]{amount, unit}));
        }
        if (ingredient.getChance() == 0.0) {
            tooltips.add((Component)Component.m_237115_((String)"custommachinery.jei.ingredient.chance.0").m_130940_(ChatFormatting.DARK_RED));
        }
        if (ingredient.getChance() < 1.0 && ingredient.getChance() > 0.0) {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{(int)(ingredient.getChance() * 100.0)}));
        }
        return tooltips;
    }
}

