/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.client.integration.jei.energy.EnergyJEIIngredientRenderer;
import fr.frinn.custommachinery.common.guielement.EnergyGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EnergyIngredientWrapper
implements IJEIIngredientWrapper<Energy> {
    private final RequirementIOMode mode;
    private final int recipeTime;
    private final Energy energy;

    public EnergyIngredientWrapper(RequirementIOMode mode, int amount, double chance, boolean isPerTick, int recipeTime) {
        this.mode = mode;
        this.recipeTime = recipeTime;
        this.energy = new Energy(amount, chance, isPerTick);
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        EnergyGuiElement energyElement;
        block3: {
            block2: {
                if (!(element instanceof EnergyGuiElement)) break block2;
                energyElement = (EnergyGuiElement)element;
                if (element.getType() == Registration.ENERGY_GUI_ELEMENT.get()) break block3;
            }
            return false;
        }
        ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset + 1, element.getY() - yOffset + 1).setCustomRenderer(CustomIngredientTypes.ENERGY, (IIngredientRenderer)new EnergyJEIIngredientRenderer(energyElement)).addIngredient(CustomIngredientTypes.ENERGY, (Object)this.energy)).addTooltipCallback((recipeSlotView, tooltip) -> {
            MutableComponent component;
            String amount = Utils.format(this.energy.getAmount());
            Component unit = PlatformHelper.energy().unit();
            if (this.energy.isPerTick()) {
                String totalEnergy = Utils.format(this.energy.getAmount() * this.recipeTime);
                component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.energy.pertick.input", (Object[])new Object[]{totalEnergy, unit, amount, unit}) : Component.m_237110_((String)"custommachinery.jei.ingredient.energy.pertick.output", (Object[])new Object[]{totalEnergy, unit, amount, unit});
            } else {
                component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.energy.input", (Object[])new Object[]{amount, unit}) : Component.m_237110_((String)"custommachinery.jei.ingredient.energy.output", (Object[])new Object[]{amount, unit});
            }
            tooltip.set(0, component);
        });
        return true;
    }
}

