/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.client.integration.jei.experience.ExperienceJEIIngredientRenderer;
import fr.frinn.custommachinery.common.guielement.ExperienceGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.Experience;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ExperienceIngredientWrapper
implements IJEIIngredientWrapper<Experience> {
    private final RequirementIOMode mode;
    private final int recipeTime;
    private final Experience experience;

    public ExperienceIngredientWrapper(RequirementIOMode mode, int amount, double chance, boolean isPerTick, int recipeTime, Experience.Form type) {
        this.mode = mode;
        this.recipeTime = recipeTime;
        this.experience = new Experience(amount, chance, isPerTick, type);
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        ExperienceGuiElement experienceElement;
        block3: {
            block2: {
                if (!(element instanceof ExperienceGuiElement)) break block2;
                experienceElement = (ExperienceGuiElement)element;
                if (element.getType() == Registration.EXPERIENCE_GUI_ELEMENT.get() && experienceElement.getMode().isDisplay()) break block3;
            }
            return false;
        }
        ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset + 1, element.getY() - yOffset + 1).setCustomRenderer(CustomIngredientTypes.EXPERIENCE, (IIngredientRenderer)new ExperienceJEIIngredientRenderer(experienceElement)).addIngredient(CustomIngredientTypes.EXPERIENCE, (Object)this.experience)).addTooltipCallback((recipeSlotView, tooltip) -> {
            MutableComponent component;
            String amount = Utils.format(this.experience.getXp());
            if (this.experience.isPoints()) {
                if (this.experience.isPerTick()) {
                    String totalExperience = Utils.format(this.experience.getXp() * this.recipeTime);
                    component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.xp.pertick.input", (Object[])new Object[]{totalExperience, "XP", amount, "XP"}) : Component.m_237110_((String)"custommachinery.jei.ingredient.xp.pertick.output", (Object[])new Object[]{totalExperience, "XP", amount, "XP"});
                } else {
                    component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.xp.input", (Object[])new Object[]{amount, "XP"}) : Component.m_237110_((String)"custommachinery.jei.ingredient.xp.output", (Object[])new Object[]{amount, "XP"});
                }
            } else if (this.experience.isPerTick()) {
                String totalExperience = Utils.format(this.experience.getLevels() * this.recipeTime);
                component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.xp.pertick.input", (Object[])new Object[]{totalExperience, "Level(s)", amount, "Level(s)"}) : Component.m_237110_((String)"custommachinery.jei.ingredient.xp.pertick.output", (Object[])new Object[]{totalExperience, "Level(s)", amount, "Level(s)"});
            } else {
                component = this.mode == RequirementIOMode.INPUT ? Component.m_237110_((String)"custommachinery.jei.ingredient.xp.input", (Object[])new Object[]{amount, "Level(s)"}) : Component.m_237110_((String)"custommachinery.jei.ingredient.xp.output", (Object[])new Object[]{amount, "Level(s)"});
            }
            tooltip.set(0, component);
        });
        return true;
    }
}

