/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render.element;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.render.FluidRenderer;
import fr.frinn.custommachinery.common.guielement.FluidGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FluidGuiElementWidget
extends TexturedGuiElementWidget<FluidGuiElement> {
    public FluidGuiElementWidget(FluidGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.m_237113_((String)"Fluid"));
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(fluidHandler -> fluidHandler.getComponentForID(((FluidGuiElement)this.getElement()).getComponentId())).ifPresent(component -> FluidRenderer.renderFluid(poseStack, this.f_93620_ + 1, this.f_93621_ + 1, this.f_93618_ - 2, this.f_93619_ - 2, component.getFluidStack(), component.getCapacity()));
        if (this.m_198029_() && ((FluidGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight(poseStack, this.f_93620_ + 1, this.f_93621_ + 1, this.f_93618_ - 2, this.f_93619_ - 2);
        }
    }

    @Override
    public List<Component> getTooltips() {
        if (!((FluidGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((FluidGuiElement)this.getElement()).getTooltips();
        }
        return this.getScreen().getTile().getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(fluidHandler -> fluidHandler.getComponentForID(((FluidGuiElement)this.getElement()).getComponentId())).map(component -> {
            long amount = component.getFluidStack().getAmount() * 1000L / FluidStackHooks.bucketAmount();
            long capacity = component.getCapacity() * 1000L / FluidStackHooks.bucketAmount();
            MutableComponent tooltip = !component.getFluidStack().isEmpty() && amount > 0L ? Component.m_237115_((String)component.getFluidStack().getTranslationKey()).m_7220_((Component)Component.m_237110_((String)"custommachinery.gui.element.fluid.tooltip", (Object[])new Object[]{Utils.format(amount), Utils.format(capacity)})) : Component.m_237110_((String)"custommachinery.gui.element.fluid.empty", (Object[])new Object[]{0, Utils.format(capacity)});
            return Collections.singletonList(tooltip);
        }).orElse(Collections.emptyList());
    }

    @Override
    public boolean isClickable() {
        return true;
    }
}

